/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.project;

import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.view.ReviewFilters;

public class ProjectReviewCounts {
    private final Principal principal;
    private final Project project;
    private final ReviewFilters filters;
    private int draftReviews = -1;
    private int allReviews = -1;
    private int openReviews = -1;
    private int closedReviews = -1;

    public ProjectReviewCounts(Principal principal, Project project) {
        this.principal = principal;
        this.project = project;
        this.filters = new ReviewFilters(project);
    }

    public int getCountDraftReviews() {
        if (this.draftReviews == -1) {
            this.draftReviews = ReviewManager.countVisibleReviews(this.principal, this.filters.getAllDraftReviewsFilterDef());
        }
        return this.draftReviews;
    }

    public int getCountAllReviews() {
        if (this.allReviews == -1) {
            this.allReviews = ReviewManager.countVisibleReviews(this.principal, this.filters.getAllReviewsFilterDef());
        }
        return this.allReviews;
    }

    public int getCountAllOpenReviews() {
        if (this.openReviews == -1) {
            this.openReviews = ReviewManager.countVisibleReviews(this.principal, this.filters.getAllOpenReviewsFilterDef());
        }
        return this.openReviews;
    }

    public int getCountAllClosedReviews() {
        if (this.closedReviews == -1) {
            this.closedReviews = ReviewManager.countVisibleReviews(this.principal, this.filters.getAllClosedReviewsFilterDef());
        }
        return this.closedReviews;
    }

    public int getCountForFilter(String filter) {
        if (this.filters.getAllDraftReviewsFilterDef().filterName.equals(filter)) {
            return this.getCountDraftReviews();
        }
        if (this.filters.getAllReviewsFilterDef().filterName.equals(filter)) {
            return this.getCountAllReviews();
        }
        if (this.filters.getAllOpenReviewsFilterDef().filterName.equals(filter)) {
            return this.getCountAllOpenReviews();
        }
        if (this.filters.getAllClosedReviewsFilterDef().filterName.equals(filter)) {
            return this.getCountAllClosedReviews();
        }
        throw new RuntimeException("Unexpected filter name '" + filter + "'");
    }
}

