/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserManager;
import java.util.Date;

public class CrucibleUser {
    private String userName;
    private Integer id;
    private FEUser feuser;
    private boolean feUserLazyLoaded = false;
    private Boolean dontSendMeMyNotifications = Boolean.TRUE;
    private Integer stateChangeEmailNotification = DeliverySchedule.IMMEDIATE;
    private Integer commentEmailNotification = DeliverySchedule.IMMEDIATE;
    private Integer replyEmailNotification = DeliverySchedule.IMMEDIATE;
    private Integer generalEmailNotification = DeliverySchedule.IMMEDIATE;
    private Integer completeEmailNotification = DeliverySchedule.IMMEDIATE;

    public void setFeuser(FEUser feuser) {
        this.feuser = feuser;
        this.feUserLazyLoaded = true;
    }

    private boolean initFeUser() {
        if (!this.feUserLazyLoaded) {
            UserManager feum = AppConfig.getsConfig().getUserManager();
            try {
                this.feuser = feum.getUser(this.userName);
                this.feUserLazyLoaded = true;
            }
            catch (DbException e2) {
                throw new RuntimeException("Could not lazily initialize user", e2);
            }
        }
        return this.feuser != null;
    }

    public Date getCreateDate() {
        return new Date();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FEUser getFEUser() {
        if (this.initFeUser()) {
            return this.feuser;
        }
        return null;
    }

    public String getDisplayName() {
        if (this.initFeUser()) {
            return this.feuser.getDisplayName();
        }
        return this.userName;
    }

    public String getEmail() {
        if (this.initFeUser()) {
            return this.feuser.getEmail();
        }
        return null;
    }

    public String getEmailStr() {
        String email = this.getEmail();
        return email == null ? "" : email;
    }

    public boolean isActive() {
        return this.initFeUser();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrucibleUser)) {
            return false;
        }
        CrucibleUser user = (CrucibleUser)o;
        return this.userName.equals(user.getUserName());
    }

    public int hashCode() {
        return this.getUserName().hashCode();
    }

    public Boolean getDontSendMeMyNotifications() {
        return this.dontSendMeMyNotifications;
    }

    public void setDontSendMeMyNotifications(Boolean dontSendMeMyNotifications) {
        this.dontSendMeMyNotifications = dontSendMeMyNotifications;
    }

    public Integer getStateChangeEmailNotification() {
        return this.stateChangeEmailNotification;
    }

    public void setStateChangeEmailNotification(Integer stateChangeEmailNotification) {
        this.stateChangeEmailNotification = stateChangeEmailNotification;
    }

    public Integer getCommentEmailNotification() {
        return this.commentEmailNotification;
    }

    public void setCommentEmailNotification(Integer commentEmailNotification) {
        this.commentEmailNotification = commentEmailNotification;
    }

    public Integer getReplyEmailNotification() {
        return this.replyEmailNotification;
    }

    public void setReplyEmailNotification(Integer replyEmailNotification) {
        this.replyEmailNotification = replyEmailNotification;
    }

    public Integer getGeneralEmailNotification() {
        return this.generalEmailNotification;
    }

    public void setGeneralEmailNotification(Integer generalEmailNotification) {
        this.generalEmailNotification = generalEmailNotification;
    }

    public Integer getCompleteEmailNotification() {
        return this.completeEmailNotification;
    }

    public void setCompleteEmailNotification(Integer completeEmailNotification) {
        this.completeEmailNotification = completeEmailNotification;
    }

    public String toString() {
        return this.getId() + ": " + this.getUserName() + " - " + super.toString();
    }
}

