/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FRXManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static FileRevisionExtraInfo getByPermaId(String permaId) {
        return FRXManager.getById(FileRevisionExtraInfo.getIdFromPermaId(permaId));
    }

    public static FileRevisionExtraInfo getById(Integer id) {
        return id == null ? null : (FileRevisionExtraInfo)FRXManager.session().get(FileRevisionExtraInfo.class, (Serializable)id);
    }

    public static FileRevisionExtraInfo createAndAddFRX(FileRevision fr, Review review) {
        FileRevisionExtraInfo frx = FRXManager.getFRExtraInfo(fr, review);
        if (frx == null) {
            frx = new FileRevisionExtraInfo(review, fr, new Date());
            review.getFrxs().add(frx);
            FRXManager.session().save((Object)frx);
        }
        return frx;
    }

    public static FileRevisionExtraInfo getFRExtraInfo(FileRevision fr, Review review) {
        Query q = FRXManager.session().createQuery("select frx from FileRevisionExtraInfo frx where frx.frr.review = :review and frx.frr.fileRevision = :fr");
        q.setEntity("review", (Object)review);
        q.setEntity("fr", (Object)fr);
        return (FileRevisionExtraInfo)q.uniqueResult();
    }

    public static List<FileRevisionExtraInfo> getFRExtraInfos(FileRevision fr) {
        Query q = FRXManager.session().createQuery("select frx from FileRevisionExtraInfo frx where frx.frr.fileRevision = :fr");
        q.setEntity("fr", (Object)fr);
        return q.list();
    }

    public static List<FileRevisionExtraInfo> getFRExtraInfos(String path, Review review) {
        Query q = FRXManager.session().createQuery("select frx from FileRevisionExtraInfo frx where frx.frr.review = :review and frx.frr.fileRevision.spr.path = :path");
        q.setEntity("review", (Object)review);
        q.setString("path", path);
        return q.list();
    }

    public static void delete(FileRevisionExtraInfo frx) {
        FRXManager.session().delete((Object)frx);
    }

    public static List getFRXs(Review review) {
        return FRXManager.getFRXs(review, null, false);
    }

    public static List getFRXs(Review review, Date whenAdded, boolean before) {
        String qstr = "select frx from FileRevisionExtraInfo frx where frx.frr.review = :review";
        if (whenAdded != null) {
            qstr = qstr + " and frx.whenAdded " + (before ? "<=" : ">=") + " :timeStamp";
        }
        Query q = FRXManager.session().createQuery(qstr);
        q.setEntity("review", (Object)review);
        if (whenAdded != null) {
            q.setTimestamp("timeStamp", whenAdded);
        }
        List l = q.list();
        return Collections.unmodifiableList(l);
    }

    public static List<FileRevision> getFileRevisions(Review review) {
        Query q = FRXManager.session().createQuery("select fr from FileRevisionExtraInfo frx, FileRevision fr where frx.frr.review = :review and fr = frx.frr.fileRevision");
        q.setEntity("review", (Object)review);
        return Collections.checkedList(new LinkedList(q.list()), FileRevision.class);
    }
}

