/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.AllCompletedNotification;
import com.cenqua.crucible.notification.AllNoLongerCompletedNotification;
import com.cenqua.crucible.notification.CommentNotification;
import com.cenqua.crucible.notification.CompletedNotification;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.GeneralNotification;
import com.cenqua.crucible.notification.Recipient;
import com.cenqua.crucible.notification.ReplyNotification;
import com.cenqua.crucible.notification.StateNotification;
import com.cenqua.crucible.notification.UncompletedNotification;
import com.cenqua.fisheye.logging.Logs;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.hibernate.Query;
import org.hibernate.Session;

public class NotificationManager {
    public static final NotificationManager INSTANCE = new NotificationManager();
    public static final Integer TYPE_NONE = new Integer(0);
    public static final Integer TYPE_STATE_CHANGE = new Integer(1);
    public static final Integer TYPE_GENERAL = new Integer(2);
    public static final Integer TYPE_REVIEWER_COMPLETE = new Integer(3);
    public static final Integer TYPE_ALL_COMPLETE = new Integer(4);
    public static final Integer TYPE_COMMENTED = new Integer(5);
    public static final Integer TYPE_REPLIED = new Integer(6);
    public static final Integer TYPE_ALL_NO_LONGER_COMPLETE = new Integer(7);
    public static final Integer TYPE_REVIEWER_INCOMPLETE = new Integer(8);
    private static final long TIMER_INTERVAL = 1000L;
    private Timer timer = null;
    private volatile boolean processing = false;

    public synchronized void startNotifier() {
        if (this.timer == null) {
            this.timer = new Timer("Notifier");
            TimerTask noteRunner = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        NotificationManager.this.processing = true;
                        NotificationManager.this.processNotifications();
                    }
                    catch (Exception e2) {
                        Logs.APP_LOG.error((Object)"Error while processing notifications: ", (Throwable)e2);
                    }
                    finally {
                        NotificationManager.this.processing = false;
                    }
                }
            };
            this.timer.schedule(noteRunner, 1000L, 1000L);
            Logs.APP_LOG.info((Object)"Notifier started.");
        }
    }

    public synchronized void stopNotifier() {
        Logs.APP_LOG.debug((Object)("Stopping " + NotificationManager.class));
        if (this.timer != null) {
            this.timer.cancel();
            try {
                while (this.processing) {
                    Thread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.timer = null;
        Logs.APP_LOG.debug((Object)(NotificationManager.class + " successfully stopped"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        try {
            HibernateUtil.beginTransaction();
            Logs.CRUC_NTF_LOG.debug((Object)"Processing notifications");
            Query q = NotificationManager.session().createQuery("from Recipient where email = :email");
            q.setInteger("email", DeliverySchedule.IMMEDIATE.intValue());
            for (Recipient r : q.list()) {
                r.emailNotification();
            }
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.rollbackTransaction();
        }
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public List getRssNotifications(CrucibleUser user, int numResults) {
        Query q = NotificationManager.session().createQuery("from Recipient where user = :user order by id desc");
        q.setEntity("user", (Object)user);
        q.setMaxResults(numResults);
        return q.list();
    }

    public List getRecentNotifications(Date since, int limit) {
        Query q = NotificationManager.session().createQuery("from NotificationStore where createDate > :date order by id desc");
        q.setMaxResults(limit);
        q.setDate("date", since);
        return q.list();
    }

    public List getLatestNotifications(int limit) {
        Query q = NotificationManager.session().createQuery("from NotificationStore order by id desc");
        q.setMaxResults(limit);
        return q.list();
    }

    public List getLatestNotifications(CrucibleUser user, int limit) {
        Query q = NotificationManager.session().createQuery("select note from NotificationStore note, ReviewParticipant rp where note.review = rp.ruc.review and rp.ruc.user = :user order by note.id desc");
        q.setMaxResults(limit);
        q.setEntity("user", (Object)user);
        return q.list();
    }

    public void noteStateChange(Review review, CrucibleUser user) {
        StateNotification note = new StateNotification(user, review);
        NotificationManager.session().save((Object)note);
        note.doNotify();
    }

    public void noteGeneralMsg(Review review, CrucibleUser user, CrucibleUser to, String message) {
        GeneralNotification note = new GeneralNotification(user, review, message);
        NotificationManager.session().save((Object)note);
        if (to == null) {
            note.doNotify();
        } else {
            note.doNotify(to);
        }
    }

    public void noteReviewerComplete(Review review, CrucibleUser user) {
        CompletedNotification note = new CompletedNotification(user, review);
        NotificationManager.session().save((Object)note);
        note.doNotify();
    }

    public void noteAllComplete(Review review, CrucibleUser user) {
        AllCompletedNotification note = new AllCompletedNotification(user, review);
        NotificationManager.session().save((Object)note);
        note.doNotify();
    }

    public void noteAllNoLongerComplete(Review review, CrucibleUser user) {
        AllNoLongerCompletedNotification note = new AllNoLongerCompletedNotification(user, review);
        NotificationManager.session().save((Object)note);
        note.doNotify();
    }

    public void noteCommented(Review review, Comment comment) {
        if (!review.getState().isDraftState()) {
            CommentNotification note = new CommentNotification(review, comment);
            NotificationManager.session().save((Object)note);
            note.doNotify();
        }
    }

    public void noteReplied(Review review, Comment comment, Comment reply) {
        if (!review.getState().isDraftState()) {
            ReplyNotification note = new ReplyNotification(review, comment, reply);
            NotificationManager.session().save((Object)note);
            note.doNotify();
        }
    }

    public void noteReviewerIncomplete(Review review, CrucibleUser user) {
        UncompletedNotification note = new UncompletedNotification(user, review);
        NotificationManager.session().save((Object)note);
        note.doNotify();
    }
}

