/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.reports.ChartColours;
import com.cenqua.crucible.reports.IntervalTickUnitSource;
import com.cenqua.crucible.reports.reviews.ReviewsDatasetMaker;
import com.cenqua.fisheye.vis.StackedXYAreaRenderer2TopLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;

public class ReviewChart {
    public String getImageContentType() {
        return "image/png";
    }

    public void getRenderChart(OutputStream out, int width, int height, Date from, Date to, Project project, String stateName) throws IOException {
        ReviewsDatasetMaker rdm = new ReviewsDatasetMaker(from, to, stateName, project);
        JFreeChart chart = this.createChart("", rdm.getDataSet(), "", "");
        BufferedImage image = chart.createBufferedImage(width, height);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
    }

    public JFreeChart createChart(String chartTitle, TableXYDataset lineData, String valueName, String xAxisName) {
        JFreeChart chart = ChartFactory.createXYAreaChart((String)chartTitle, (String)xAxisName, (String)valueName, (XYDataset)lineData, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setTextAntiAlias(true);
        TextTitle title = chart.getTitle();
        title.setTextAlignment(HorizontalAlignment.LEFT);
        title.setPaint((Paint)Color.WHITE);
        title.setBackgroundPaint((Paint)Color.DARK_GRAY);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRenderer((XYItemRenderer)new StackedXYAreaRenderer2TopLine());
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.setOutlineVisible(false);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setAxisLinePaint((Paint)Color.LIGHT_GRAY);
        valueAxis.setTickMarksVisible(false);
        valueAxis.setTickLabelPaint((Paint)Color.LIGHT_GRAY);
        valueAxis.setStandardTickUnits((TickUnitSource)new IntervalTickUnitSource(5.0));
        valueAxis.setAxisLineVisible(false);
        ValueAxis catAxis = plot.getDomainAxis();
        catAxis.setTickLabelsVisible(false);
        catAxis.setTickMarksVisible(false);
        catAxis.setStandardTickUnits((TickUnitSource)new IntervalTickUnitSource(1.0));
        BasicStroke stroke = new BasicStroke(1.0f);
        catAxis.setAxisLineStroke((Stroke)stroke);
        catAxis.setAxisLinePaint((Paint)Color.LIGHT_GRAY);
        StackedXYAreaRenderer2TopLine renderer = (StackedXYAreaRenderer2TopLine)plot.getRenderer();
        renderer.setSeriesPaint(0, ChartColours.areaFill);
        renderer.setSeriesOutlineStroke(0, stroke);
        renderer.setSeriesOutlinePaint(0, ChartColours.areaOutline);
        return chart;
    }
}

