/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.upload;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.hibernate.Session;

public class UploadManager {
    private static final String UPLOAD_DIR_NAME = "data/uploads";

    private static File getUploadDir() {
        File dir = new File(AppConfig.getVarDir(), UPLOAD_DIR_NAME);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            Logs.APP_LOG.warn((Object)("Could not create upload directory: " + dir));
        }
        return dir;
    }

    public static void saveItemFile(UploadItem item, File file) throws IOException {
        File newFile = UploadManager.createFileForUploadItem(item);
        IOHelper.copy(file, newFile);
    }

    public static void saveItemFileFromContent(UploadItem item, String content) throws IOException {
        File newFile = UploadManager.createFileForUploadItem(item);
        IOHelper.copyStringToFile(content, newFile);
    }

    private static File createFileForUploadItem(UploadItem item) throws IOException {
        File newFile = UploadManager.getItemFile(item);
        File dir = newFile.getParentFile();
        dir.mkdirs();
        if (!dir.isDirectory()) {
            Logs.APP_LOG.error((Object)("Could not create upload directory: " + dir));
            throw new IOException("Could not create directory to store upload.");
        }
        return newFile;
    }

    static String storageDirName(int id) {
        StringBuffer b2 = new StringBuffer();
        StringUtil.pad(b2, id, 6);
        if (b2.length() % 2 != 0) {
            b2.insert(0, '0');
        }
        b2.delete(b2.length() - 2, b2.length());
        for (int pos = b2.length() - 2; pos >= 2; pos -= 2) {
            b2.insert(pos, '/');
        }
        return b2.toString();
    }

    public static File getItemFile(UploadItem ui) {
        int id = ui.getId();
        File dir = new File(UploadManager.getUploadDir(), UploadManager.storageDirName(id));
        return new File(dir, id + ".dat");
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static UploadItem createUploadItem(CrucibleUser user, File file, String filename, String contentType, String description) throws IOException {
        UploadItem ui = new UploadItem(user, description);
        UploadManager.session().save((Object)ui);
        ui.setOriginalName(filename != null ? filename : file.getName());
        ui.setOriginalContentType(contentType);
        UploadManager.saveItemFile(ui, file);
        return ui;
    }

    public static UploadItem createUploadItemFromContent(CrucibleUser user, String filename, String content, String contentType, String description) throws IOException {
        UploadItem ui = new UploadItem(user, description);
        UploadManager.session().save((Object)ui);
        ui.setOriginalName(filename);
        ui.setOriginalContentType(contentType);
        UploadManager.saveItemFileFromContent(ui, content);
        return ui;
    }

    public static UploadItem getItemById(Integer id) {
        return (UploadItem)UploadManager.session().get(UploadItem.class, (Serializable)id);
    }
}

