/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class FileRevisionToReviewMapper {
    private final String source;
    private final Set<String> filesAlreadySearched = new HashSet<String>();
    private final HashMap<RevInfoKey, Set<Review>> reviewMap = new HashMap();

    public FileRevisionToReviewMapper(String source) {
        this.source = source;
    }

    private Session session() {
        return HibernateUtil.currentSession();
    }

    public Collection findReviewsForRevision(RevInfoKey rk) {
        this.doSearch(rk);
        Set result = this.reviewMap.get(rk);
        return result != null ? result : Collections.EMPTY_SET;
    }

    private void doSearch(RevInfoKey rk) {
        String path = rk.getPath().getPath();
        if (this.filesAlreadySearched.contains(path)) {
            return;
        }
        this.filesAlreadySearched.add(path);
        Query q = this.session().createQuery("select review , fr.spr.path, fr.spr.revIdent from Review review join review.frxs frx join frx.frr.fileRevision fr where fr.spr.sourceName = :source and fr.spr.path = :path");
        q.setString("source", this.source);
        q.setString("path", path);
        List rs = q.list();
        for (Object r1 : rs) {
            Object[] row = (Object[])r1;
            Review review = (Review)row[0];
            String p = (String)row[1];
            String r = (String)row[2];
            RevInfoKey k = new RevInfoKey(new Path(p), r);
            Set<Review> reviews = this.reviewMap.get(k);
            if (reviews == null) {
                reviews = new LinkedHashSet<Review>();
                this.reviewMap.put(k, reviews);
            }
            reviews.add(review);
        }
    }
}

