/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.revision.FileInfo;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.view.DiffDO;
import com.cenqua.crucible.view.LineDO;
import com.cenqua.crucible.view.RevisionCommentDO;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FRXDO {
    protected FileRevisionExtraInfo frx;
    private HashMap<Comment, RevisionCommentDO> rcCommentMap;
    private ArrayList<RevisionCommentDO> comments;
    private ArrayList<RevisionCommentDO> wholeRevisionComments;
    private ArrayList<RevisionComment> deletedComments;
    private LinkedList lines;
    private CrucibleUser currentUser;
    private FileRevision fromRevision;
    private int diffContext = 3;
    private boolean ignore_BL = true;
    private boolean ignore_w = false;
    private boolean ignore_b = true;
    private String keywordOpts;
    private String errorMsg;
    private Source source;
    private DiffDO diffDO;
    private FileInfo fileInfo;
    private DiffPrinter diffPrinterCache;
    private boolean sideBySide;
    private boolean softWrap;
    private Boolean isText = null;

    public FRXDO(FileRevisionExtraInfo frx, CrucibleUser currentUser, String keywordOpts, boolean sideBySide, boolean softWrap) throws Exception {
        this.softWrap = softWrap;
        this.sideBySide = sideBySide;
        this.currentUser = currentUser;
        try {
            this.setKeywordOpts(keywordOpts);
            this.setFRX(frx);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Unexpected error creating FRX", (Throwable)e2);
            throw e2;
        }
    }

    public Integer getId() {
        return this.frx.getId();
    }

    public Review getReview() {
        return this.frx.getReview();
    }

    public String getPermaId() {
        return this.frx.getPermaId();
    }

    private void setFRX(FileRevisionExtraInfo frx) throws Exception {
        if (frx == null) {
            throw new Exception("Setting FRXDO frx to null.");
        }
        this.frx = frx;
        this.fromRevision = frx.getFromRevision();
        this.source = frx.getFileRevision().getSource();
        this.mapComments();
    }

    public FileRevision getFromRevision() {
        return this.fromRevision;
    }

    public void setFromRevision(FileRevision fromRevision) {
        this.fromRevision = fromRevision;
    }

    public int getDiffContext() {
        return this.diffContext;
    }

    public void setDiffContext(int diffContext) {
        this.diffContext = diffContext;
        this.diffPrinterCache = null;
    }

    public boolean isIgnore_BL() {
        return this.ignore_BL;
    }

    public void setIgnore_BL(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
        this.diffPrinterCache = null;
    }

    public boolean isIgnore_w() {
        return this.ignore_w;
    }

    public void setIgnore_w(boolean ignore_w) {
        this.ignore_w = ignore_w;
        this.diffPrinterCache = null;
    }

    public boolean isIgnore_b() {
        return this.ignore_b;
    }

    public void setIgnore_b(boolean ignore_b) {
        this.ignore_b = ignore_b;
        this.diffPrinterCache = null;
    }

    public String getDiffOption() {
        return (this.ignore_BL ? "B" : "") + (this.ignore_b ? "b" : "") + (this.ignore_w ? "w" : "");
    }

    public String getKeywordOpts() {
        return this.keywordOpts;
    }

    public void setKeywordOpts(String keywordOpts) {
        this.diffPrinterCache = null;
        this.keywordOpts = keywordOpts;
    }

    public FileRevision getToRevision() {
        return this.frx.getFileRevision();
    }

    public Path getFePath() {
        return this.frx.getFileRevision().getFePath();
    }

    public String getPath() {
        return this.frx.getFileRevision().getPath();
    }

    public ReviewParticipant getParticipant() {
        return ParticipantManager.getByUser(this.getReview(), this.getCurrentUser());
    }

    public CrucibleUser getCurrentUser() {
        return this.currentUser;
    }

    public boolean isComplete() {
        ReviewParticipant p = this.getParticipant();
        return p != null && p.getCompletedFrxs().contains(this.frx);
    }

    public boolean isPatch() {
        return this.source instanceof PatchSource;
    }

    public boolean isRepositorySource() {
        return this.source instanceof RepositorySource;
    }

    public boolean isSideBySide() throws Exception {
        return this.getDiffPrinter().isSideBySide();
    }

    public String getDiffColumns() throws Exception {
        return this.isSideBySide() ? "8" : "4";
    }

    public FileInfo getFileInfo() {
        if (this.fileInfo == null) {
            try {
                this.fileInfo = this.frx.getFileRevision().getFileInfo();
            }
            catch (FileRevisionException e2) {
                this.errorMsg = this.source.getReason();
            }
            if (!this.fileInfo.isDisplayable()) {
                this.errorMsg = "File revision not found";
            }
        }
        return this.fileInfo;
    }

    public String getFileType() {
        FileInfo fileInfo = this.getFileInfo();
        if (fileInfo == null) {
            return "?";
        }
        if (fileInfo.isBinary()) {
            return "binary";
        }
        if (fileInfo.isDirectory()) {
            return "directory";
        }
        return "text";
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public boolean isDisplayable() {
        if (!this.source.isAvailable()) {
            this.errorMsg = this.source.getReason();
            return false;
        }
        return this.getFileInfo() != null && this.getFileInfo().isDisplayable();
    }

    public Source getSource() {
        return this.source;
    }

    public abstract boolean isAdded();

    public abstract boolean isDeleted();

    public abstract boolean isChanged();

    public abstract boolean isMoved();

    public abstract boolean isCopied();

    public boolean isText() throws FileRevisionException {
        if (this.isText == null) {
            boolean text;
            boolean bl = text = this.getFileInfo() != null && this.getFileInfo().isText();
            if (text && !this.isOneFile()) {
                text = !this.getFromRevision().getFileInfo().isBinary();
            }
            this.isText = text;
        }
        return this.isText;
    }

    public boolean isDir() {
        return this.getFileInfo() != null && this.getFileInfo().isDirectory();
    }

    public boolean isBinary() {
        return this.getFileInfo() != null && this.getFileInfo().isBinary();
    }

    public boolean isAnnotatable() {
        return this.getFileInfo() != null && this.getFileInfo().isAnnotatable();
    }

    public boolean isOneFile() {
        return this.getFromRevision() == null;
    }

    public boolean isDisplayDiff() throws FileRevisionException {
        return this.isText() && !this.isOneFile();
    }

    public boolean isDisplayBinary() {
        return this.isBinary() && !this.isDeleted();
    }

    public boolean isDisplayAnnotation() throws FileRevisionException {
        return this.isText() && this.isOneFile() && !this.isDeleted() && this.isAnnotatable();
    }

    public boolean isDiffable() throws FileRevisionException {
        return this.getFileInfo() != null && this.getFileInfo().isDiffable();
    }

    private void mapComments() {
        this.rcCommentMap = new HashMap();
        this.wholeRevisionComments = new ArrayList();
        this.deletedComments = new ArrayList();
        for (RevisionComment rcomment : this.frx.getRevisionComments()) {
            if (rcomment.isDraft() && !rcomment.getComment().getUser().equals(this.currentUser)) continue;
            if (rcomment.isDeleted()) {
                this.deletedComments.add(rcomment);
                continue;
            }
            if (rcomment.isWholeRevisionComment()) {
                this.wholeRevisionComments.add(new RevisionCommentDO(rcomment, null));
                continue;
            }
            if (!this.rcCommentMap.containsKey(rcomment.getComment())) {
                RevisionCommentDO rcdo = new RevisionCommentDO();
                rcdo.setCurrentUser(this.currentUser);
                this.rcCommentMap.put(rcomment.getComment(), rcdo);
            }
            if (rcomment.getRevision().equals(this.frx.getFileRevision())) {
                this.rcCommentMap.get(rcomment.getComment()).setToRC(rcomment);
                continue;
            }
            this.rcCommentMap.get(rcomment.getComment()).setFromRC(rcomment);
        }
        this.comments = new ArrayList();
        this.comments.addAll(this.rcCommentMap.values());
        Collections.sort(this.comments, OldestFirstComparator.INSTANCE);
    }

    public RevisionCommentDO getRCDOFromComment(Comment comment) {
        return this.rcCommentMap.get(comment);
    }

    public List<RevisionCommentDO> getFromCommentsOnLine(int line) {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            if (!rcdo.isLastFromLine(line)) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List<RevisionCommentDO> getToCommentsOnLine(int line) {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            if (!rcdo.isLastToLine(line)) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List<RevisionCommentDO> getToCommentsOnLastLine(int line) {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            if (rcdo.getLastTo() != line) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List<RevisionCommentDO> getFromCommentsOnLastLine(int line) {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            if (rcdo.getLastFrom() != line) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List<RevisionCommentDO> getAllCommentsBetweenLines(int startTo, int startFrom, int endTo, int endFrom) {
        ArrayList<RevisionCommentDO> comments;
        block2: {
            block3: {
                comments = new ArrayList<RevisionCommentDO>();
                if (endTo - startTo != endFrom - startFrom || endTo - startTo <= 1) break block2;
                if (endTo == -1) break block3;
                for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
                    int lastTo = rcdo.getLastTo();
                    if (lastTo == -1 || lastTo <= startTo || lastTo >= endTo) continue;
                    comments.add(rcdo);
                }
                break block2;
            }
            if (endFrom == -1) break block2;
            for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
                int lastFrom = rcdo.getLastFrom();
                if (lastFrom == -1 || lastFrom <= startFrom || lastFrom >= endFrom) continue;
                comments.add(rcdo);
            }
        }
        return comments;
    }

    private List<RevisionCommentDO> getCommentsAfterLine(LinePair.Line to, LinePair.Line from) {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            int lastTo = rcdo.getLastTo() - 1;
            int lastFrom = rcdo.getLastFrom() - 1;
            if ((lastTo == -1 || to == null || lastTo <= to.getLineNumber()) && (lastFrom == -1 || from == null || lastFrom <= from.getLineNumber())) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List<RevisionCommentDO> getFromOnlyComments() {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            if (!rcdo.isFromOnly()) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List<RevisionCommentDO> getToOnlyComments() {
        ArrayList<RevisionCommentDO> comments = new ArrayList<RevisionCommentDO>();
        for (RevisionCommentDO rcdo : this.rcCommentMap.values()) {
            if (!rcdo.isToOnly()) continue;
            comments.add(rcdo);
        }
        return comments;
    }

    public List getComments() {
        return this.comments;
    }

    public ArrayList<RevisionCommentDO> getWholeRevisionComments() {
        return this.wholeRevisionComments;
    }

    public ArrayList<RevisionComment> getDeletedComments() {
        return this.deletedComments;
    }

    public boolean isHasComments() {
        return !this.rcCommentMap.isEmpty() || !this.wholeRevisionComments.isEmpty();
    }

    public List getAnnotatedAncestors() throws Exception {
        return this.source.getAnnotatedAncestors(this.frx);
    }

    public List<RevisionCommentDO> getCommentsAfterLastLine() throws Exception {
        LineDO lastLine = (LineDO)this.getLines().getLast();
        return this.getCommentsAfterLine(lastLine.getLinePair().getTo(), lastLine.getLinePair().getFrom());
    }

    public boolean isNoChange() throws Exception {
        try {
            return this.isDisplayDiff() && (this.getLines() == null || this.getLines().isEmpty());
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2);
            throw e2;
        }
    }

    public DiffDO getDiffDO() {
        if (this.diffDO == null) {
            this.diffDO = new DiffDO(this);
        }
        return this.diffDO;
    }

    public LinkedList getLines() throws Exception {
        try {
            if (this.lines == null) {
                this.lines = this.getDiffDO().mapCommentsToDiff();
            }
            return this.lines;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2);
            throw e2;
        }
    }

    public DiffPrinter getDiffPrinter() throws Exception {
        if (this.diffPrinterCache == null) {
            this.diffPrinterCache = this.getSource().getDiffPrinter(this.frx, this.getKeywordOpts(), this.getDiffOption(), this.getDiffContext(), this.sideBySide, this.softWrap);
        }
        return this.diffPrinterCache;
    }

    public static class OldestFirstComparator
    implements Comparator {
        public static final OldestFirstComparator INSTANCE = new OldestFirstComparator();

        public int compare(Object o1, Object o2) {
            long b2;
            long a2 = ((RevisionCommentDO)o1).getCommentDO().getCreateDate().getTime();
            if (a2 > (b2 = ((RevisionCommentDO)o2).getCommentDO().getCreateDate().getTime())) {
                return 1;
            }
            if (a2 < b2) {
                return -1;
            }
            return 0;
        }
    }
}

