/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchDO {
    private Patch patch;
    private List<FileRevision> filesInReview;
    private List<FileRevision> diffRevisions;

    public PatchDO(Patch patch) {
        this.patch = patch;
    }

    public String getSourceName() {
        return "PATCH:" + this.patch.getId();
    }

    public Integer getPatchId() {
        return this.patch.getId();
    }

    public List<FileRevision> getDiffRevisions() {
        if (this.diffRevisions == null) {
            try {
                this.diffRevisions = new LinkedList<FileRevision>();
                for (DiffRevisionsInfo dri : this.patch.getDiffRevisions()) {
                    this.diffRevisions.add(this.patch.getFileRevisionFromDRI(dri));
                }
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Problem getting patch information.", (Throwable)e2);
            }
        }
        return this.diffRevisions;
    }

    private List<FileRevision> getFilesInReview() {
        if (this.filesInReview == null) {
            this.filesInReview = this.patch.getReview().getAllReviewFileRevisions();
        }
        return this.filesInReview;
    }

    public boolean isAllItemsInReview() {
        return this.filesInReview.size() != 0 && this.patch.getFileRevisions() != null && this.getFilesInReview().containsAll(this.getDiffRevisions());
    }

    public boolean isSomeItemsInReview() {
        List<FileRevision> filesInReview = this.getFilesInReview();
        if (this.isAllItemsInReview() || this.patch.getFileRevisions() == null) {
            return false;
        }
        for (FileRevision o : filesInReview) {
            if (!this.patch.getFileRevisions().contains(o)) continue;
            return true;
        }
        return false;
    }
}

