/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.api;

import com.cenqua.fisheye.api.ApiImplementation;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.io.IOException;
import java.io.Reader;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class XmlRpcApiHandler
extends BaseApiHandler {
    private Elements mParams;

    public String parseCommand() throws IOException {
        Document doc;
        try {
            Builder builder = new Builder();
            doc = builder.build((Reader)this.context.getReader());
        }
        catch (ParsingException e2) {
            ApiImplementation.logApiException(e2);
            this.sendError("error parsing request: " + e2.getMessage());
            return null;
        }
        Element root = doc.getRootElement();
        if (!"methodCall".equals(root.getLocalName())) {
            this.sendError("you need to send a <methodCall>");
            return null;
        }
        Element methodName = root.getFirstChildElement("methodName");
        if (methodName == null) {
            this.sendError("you need to specify a <methodName>");
            return null;
        }
        Element params = root.getFirstChildElement("params");
        if (params != null) {
            this.mParams = params.getChildElements("param");
        }
        return methodName.getValue();
    }

    public String getStringParam(int pos, String name) {
        Element str = this.getParamValue(pos, name, "string");
        if (str == null) {
            return null;
        }
        return str.getValue();
    }

    public Long getDateParam(int pos, String name) {
        Element str = this.getParamValue(pos, name, "dateTime.iso8601");
        if (str == null) {
            return null;
        }
        String v = str.getValue();
        try {
            return ISO8601DateHelper.parse(v).getTime();
        }
        catch (ISO8601DateHelper.InvalidDateException e2) {
            ApiImplementation.logApiException(e2);
            this.mErrorMessages.add("parameter '" + name + "' was not a date: " + e2.getMessage());
            return null;
        }
    }

    public Long getLongParam(int pos, String name) {
        Element str = this.getParamValue(pos, name, "i4");
        if (str == null) {
            str = this.getParamValue(pos, name, "int");
        }
        if (str == null) {
            return null;
        }
        try {
            return new Long(str.getValue());
        }
        catch (NumberFormatException e2) {
            ApiImplementation.logApiException(e2);
            this.mErrorMessages.add("parameter '" + name + "' was not an integer/long");
            return null;
        }
    }

    private Element getParamValue(int pos, String name, String type) {
        int nGiven;
        int n = nGiven = this.mParams == null ? 0 : this.mParams.size();
        if (pos >= nGiven) {
            return null;
        }
        Element param = this.mParams.get(pos);
        Element value = param.getFirstChildElement("value");
        if (value == null) {
            this.mErrorMessages.add("<param> missing <value>");
            return null;
        }
        int ntypes = value.getChildElements().size();
        if (ntypes == 0) {
            if (type.equals("string")) {
                return value;
            }
            this.mErrorMessages.add("Expected " + type + ". Parameter '" + name + "' was anon-string instead (argument number " + (pos + 1) + ").");
            return null;
        }
        if (ntypes != 1) {
            this.mErrorMessages.add("Too many types in <value>, expected " + type + ". Parameter '" + name + "' (argument number " + (pos + 1) + ").");
            return null;
        }
        Element holder = value.getChildElements().get(0);
        String holderType = holder.getLocalName();
        if (!type.equals(holderType)) {
            this.mErrorMessages.add("Expected " + type + " found " + holderType + ". Parameter '" + name + "' wrong type (argument number " + (pos + 1) + ").");
            return null;
        }
        return holder;
    }

    protected void openResponse() {
        this.out.print("<methodResponse><params><param><value>");
    }

    protected void closeResponse() {
        this.out.println("</value></param></params></methodResponse>");
    }

    public void openArrayMember(String name) {
        this.out.print("<member><name>");
        this.out.print(name);
        this.out.println("</name><value><array><data>");
    }

    public void closeArrayMember(String s) {
        this.out.println("</data></array></value></member>");
    }

    public void openArray() {
        this.out.println("<array><data>");
    }

    public void closeArray() {
        this.out.println("</data></array>");
    }

    public void openArrayValue() {
        this.out.print("<value>");
    }

    public void closeArrayValue() {
        this.out.print("</value>");
    }

    public void openStruct0(String s) {
        this.out.println("<struct>");
    }

    public void openStruct1() {
    }

    public void closeStruct0(String s) {
        this.out.println("</struct>");
    }

    public void closeStruct(String s) {
        this.out.println("</struct>");
    }

    public void writeTextAttribute(String name, String value) throws IOException {
        this.out.print("<member><name>");
        this.out.print(name);
        this.out.print("</name><value><string>");
        XmlRpcApiHandler.xmlEscape(this.out, value);
        this.out.println("</string></value></member>");
    }

    public void writeTextMember(String name, String value) throws IOException {
        this.writeTextAttribute(name, value);
    }

    public void writeDateAttribute(String name, long value) throws IOException {
        this.out.print("<member><name>");
        this.out.print(name);
        this.out.print("</name><value><dateTime.iso8601>");
        this.out.print(ISO8601DateHelper.toXmlRpcDate(value));
        this.out.println("</dateTime.iso8601></value></member>");
    }

    public void writeDateMember(String name, long value) throws IOException {
        this.writeDateAttribute(name, value);
    }

    public void writeBooleanAttribute(String name, boolean value) throws IOException {
        this.out.print("<member><name>");
        this.out.print(name);
        this.out.print("</name><value><boolean>");
        XmlRpcApiHandler.xmlEscape(this.out, value ? "1" : "0");
        this.out.println("</boolean></value></member>");
    }

    public void writeIntAttribute(String name, int value) throws IOException {
        this.out.print("<member><name>");
        this.out.print(name);
        this.out.print("</name><value><i4>");
        this.out.print(value);
        this.out.println("</i4></value></member>");
    }

    public void writeIntMember(String name, int value) throws IOException {
        this.writeIntAttribute(name, value);
    }

    public void writeTextValue(String s) throws IOException {
        this.out.print("<string>");
        XmlRpcApiHandler.xmlEscape(this.out, s);
        this.out.println("</string>");
    }

    public void writeBooleanValue(boolean b2) throws IOException {
        this.out.print("<boolean>");
        XmlRpcApiHandler.xmlEscape(this.out, b2 ? "1" : "0");
        this.out.println("</boolean>");
    }

    protected void writeError(String msg) throws IOException {
        this.out.println("<methodResponse><fault><value>");
        this.out.println("<struct>");
        this.out.println("<member><name>faultCode</name><value><int>1</int></value></member>");
        this.writeTextAttribute("faultString", msg);
        this.out.println("</struct>");
        this.out.write("</value></fault></methodResponse>");
        this.out.close();
    }
}

