/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.BucketData;
import com.cenqua.fisheye.bucket.BucketDataCollection;
import com.cenqua.fisheye.bucket.BucketDataElement;
import com.cenqua.fisheye.bucket.CalculatedBucketGraph;
import com.cenqua.fisheye.bucket.InvalidBucketException;
import com.cenqua.fisheye.bucket.Period;
import com.cenqua.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.bucket.RenamingRules;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Pair;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.SortOrder;

public class CalculatedBucketGraphPie
extends CalculatedBucketGraph {
    private DefaultPieDataset pieData = new DefaultPieDataset();
    private Date date;
    private static final double MIN_FRACTION_TO_SHOW = 0.03;
    private static final int MAX_ELEMENTS_TO_SHOW = 10;
    private TimeZone timeZone;

    public CalculatedBucketGraphPie(Date date, TimeZone timeZone) {
        this.timeZone = timeZone;
        this.date = date;
    }

    public CalculatedBucketGraphPie(Date date, BucketDataCollection bucketsAll, PeriodUnit periodSlurp, TimeZone timeZone, RenamingRules renameRules, Integer maxItems) throws DbException {
        this.timeZone = timeZone;
        this.date = date;
        for (Map.Entry<String, BucketData> data : bucketsAll) {
            this.insertValue(data.getKey(), this.getLinecountAtDate(data.getValue(), date, periodSlurp));
        }
        this.reducePieData(maxItems, renameRules);
    }

    public CalculatedBucketGraphPie(Date date, BucketDataCollection bucketsAll, PeriodUnit periodSlurp, TimeZone timeZone, RenamingRules renameRules) throws DbException {
        this.timeZone = timeZone;
        this.date = date;
        for (Map.Entry<String, BucketData> data : bucketsAll) {
            this.insertValue(data.getKey(), this.getLinecountAtDate(data.getValue(), date, periodSlurp));
        }
        this.reducePieData(10, renameRules);
    }

    private int getLinecountAtDate(BucketData bucketData, Date date, PeriodUnit periodSlurp) throws DbException {
        int linecount = 0;
        for (Map.Entry<Integer, BucketDataElement> buckets : bucketData) {
            try {
                Period period = new Period(periodSlurp, buckets.getKey(), this.timeZone);
                if (period.getStartTime() > date.getTime()) {
                    return linecount;
                }
                linecount += buckets.getValue().getLinecount();
                if (period.getEndTime() <= date.getTime()) continue;
                return linecount;
            }
            catch (InvalidBucketException e2) {
            }
        }
        return linecount;
    }

    public DefaultPieDataset getPieData() {
        return this.pieData;
    }

    public void reducePieData(int maxItems, RenamingRules renameRules) {
        int i2;
        if (renameRules != null) {
            for (Pair<String, List<String>> rule : renameRules) {
                int total = 0;
                for (String s : rule.getSecond()) {
                    Number val = this.pieData.getValue((Comparable)((Object)s));
                    if (val == null) continue;
                    total += val.intValue();
                    this.pieData.remove((Comparable)((Object)s));
                }
                if (total == 0) continue;
                this.insertValue(rule.getFirst(), total);
            }
        }
        double total = 0.0;
        for (int i3 = 0; i3 < this.pieData.getItemCount(); ++i3) {
            total += this.pieData.getValue(i3).doubleValue();
        }
        int numNotOther = this.pieData.getItemCount() == maxItems ? maxItems : Math.min(maxItems - 1, this.pieData.getItemCount());
        this.pieData.sortByValues(SortOrder.DESCENDING);
        double other = 0.0;
        for (i2 = 0; i2 < numNotOther && !(this.pieData.getValue(i2).doubleValue() / total < 0.03); ++i2) {
        }
        while (this.pieData.getItemCount() > i2) {
            other += (double)this.pieData.getValue(i2).intValue();
            this.pieData.remove(this.pieData.getKey(i2));
        }
        if (other > 0.0) {
            this.pieData.insertValue(this.pieData.getItemCount(), (Comparable)((Object)"Other"), other);
        }
    }

    public String[] getLegendItems() {
        int i2;
        String[] items = new String[this.pieData.getItemCount()];
        int total = 0;
        for (i2 = 0; i2 < items.length; ++i2) {
            total += this.pieData.getValue(i2).intValue();
        }
        for (i2 = 0; i2 < items.length; ++i2) {
            items[i2] = this.pieData.getKey(i2) + " " + Math.round(100.0f * this.pieData.getValue(i2).floatValue() / (float)total) + "% (" + this.pieData.getValue(i2).intValue() + ")";
        }
        return items;
    }

    public boolean noGraphData() {
        return this.pieData == null || this.pieData.getItemCount() == 0;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void insertValue(String key, int linecountAtDate) {
        if (this.pieData == null) {
            this.pieData = new DefaultPieDataset();
        }
        if (!key.equals("__ALL_AUTHORS__") && !key.equals("__ALL_EXTENSIONS__")) {
            key = this.formatLabel(key);
            this.pieData.insertValue(0, (Comparable)((Object)key), (double)linecountAtDate);
        }
    }
}

