/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.bucket.BucketDataCollection;
import com.cenqua.fisheye.bucket.ParameterSetInsert;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4uide._Attribute;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfinityDBConnector {
    private static final int VERSION = 11;
    private final InfinityDbHandle dbh;
    private final String repname;

    InfinityDBConnector(InfinityDbHandle dbh, String repname) {
        this.dbh = dbh;
        this.repname = repname;
    }

    public _k4uideIDB getDB() throws DbException {
        return this.dbh.get();
    }

    void closeDB() throws DbException {
        try {
            this.dbh.close();
        }
        catch (IOException e2) {
            throw new DbException("Error reading database", e2);
        }
    }

    void commitDB() throws DbException {
        try {
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException("Error committing to database", e2);
        }
    }

    private void deleteObject(Object object) throws DbException {
        try {
            this.dbh.get().deleteSubspace(object, true);
        }
        catch (IOException e2) {
            throw new DbException("Error reading database", e2);
        }
    }

    private void insert(_Cu cu) throws DbException {
        try {
            this.dbh.get().insert(cu);
        }
        catch (IOException e2) {
            throw new DbException("Error reading database", e2);
        }
    }

    private boolean retrieve(_Cu cu, int offset) throws DbException {
        try {
            return this.dbh.get().next(cu, offset);
        }
        catch (IOException e2) {
            throw new DbException("Error reading from database", e2);
        }
    }

    private void update(_Cu prefix, _Cu value) throws DbException {
        try {
            int offset = prefix.length();
            prefix.append(value);
            this.dbh.get().update(prefix, offset);
        }
        catch (IOException e2) {
            throw new DbException("Error updating database", e2);
        }
    }

    void saveDirAttribute(int dirID, _Attribute attribute, int value) throws DbException {
        this.update(_Cu.alloc().clear().append(CommonSchema.E_DIR).append(dirID).append(attribute), _Cu.alloc().append(value));
    }

    void saveBucketdataInfo(_Attribute attribute, int value, _Cu cu) throws DbException {
        this.update(cu.clear().append(CommonSchema.E_BUCKETDATA_INFO).append(attribute), _Cu.alloc().append(value));
    }

    void saveSubdirIDs(int dirID, Set<Map.Entry<String, Integer>> subdirs) throws DbException {
        for (Map.Entry<String, Integer> subdir : subdirs) {
            this.saveSubdirID(dirID, subdir.getKey(), subdir.getValue());
        }
    }

    void saveSubdirID(int dirID, String subdirName, int subdirID) throws DbException {
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_DIR).append(dirID).append(CommonSchema.A_SUBDIR_IDS).append(subdirName).append(subdirID);
        this.insert(cu);
    }

    Map<String, Integer> loadSubdirIDs(int dirID) throws DbException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_DIR).append(dirID).append(CommonSchema.A_SUBDIR_IDS);
        int prefixLength = cu.length();
        while (this.retrieve(cu, prefixLength)) {
            int offset = prefixLength;
            String name = cu.stringAt(offset);
            offset = cu.skipString(offset);
            int value = (int)cu.longAt(offset);
            result.put(name, value);
        }
        return result;
    }

    int loadSubdirID(int dirID, String name) throws DbException {
        if (dirID < 0) {
            return -1;
        }
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_DIR).append(dirID).append(CommonSchema.A_SUBDIR_IDS).append(name);
        int prefixLength = cu.length();
        if (this.retrieve(cu, prefixLength)) {
            return (int)cu.longAt(prefixLength);
        }
        return -1;
    }

    int loadDirAttribute(int dirID, _Attribute attribute, _Cu cu) throws DbException {
        return this.loadInt(cu.clear().append(CommonSchema.E_DIR).append(dirID).append(attribute));
    }

    int loadBucketdataInfo(_Attribute attribute, _Cu cu) throws DbException {
        return this.loadInt(cu.clear().append(CommonSchema.E_BUCKETDATA_INFO).append(attribute));
    }

    private int loadInt(_Cu cu) throws DbException {
        int prefixLength = cu.length();
        if (this.retrieve(cu, prefixLength)) {
            return (int)cu.longAt(prefixLength);
        }
        return -1;
    }

    int addToData(int dataID, ParameterSetInsert params, _Attribute attribute) throws DbException {
        if (dataID < 0) {
            dataID = this.getNextIdAndIncrement(CommonSchema.A_NEXT_ID_BUCKETDATA, 0);
        }
        int totalLinecount = 0;
        for (Map.Entry<String, Integer> element : params.linecountByAuthor.entrySet()) {
            String author = element.getKey();
            int linecount = element.getValue();
            totalLinecount += linecount;
            this.addToData(dataID, params, author, linecount, attribute);
        }
        this.addToData(dataID, params, "__ALL_AUTHORS__", totalLinecount, attribute);
        return dataID;
    }

    private void addToData(int dataID, ParameterSetInsert params, String author, int linecount, _Attribute attribute) throws DbException {
        this.addToData(dataID, params, author, linecount, params.extension, attribute);
        this.addToData(dataID, params, author, linecount, "__ALL_EXTENSIONS__", attribute);
    }

    private void addToData(int dataID, ParameterSetInsert params, String author, int linecount, String extn, _Attribute attribute) throws DbException {
        this.addToData(dataID, params.branch, author, extn, params.bucket, linecount, params.numRevisions, attribute);
        if (params.isTrunklike) {
            this.addToData(dataID, "__TRUNKLIKE__", author, extn, params.bucket, linecount, params.numRevisions, attribute);
        }
    }

    private void addToData(int dataID, String branch, String author, String extn, int bucket, int linecount, int revcount, _Attribute attribute) throws DbException {
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_BUCKET_DATA_NEW).append(attribute).append(dataID).append(branch).append(extn).append(author).append(bucket);
        int prefix = cu.length();
        if (this.retrieve(cu, prefix)) {
            int offset = prefix;
            linecount = (int)((long)linecount + cu.longAt(offset));
            offset = cu.skipLong(offset);
            revcount = (int)((long)revcount + cu.longAt(offset));
            this.deleteObject(cu);
        }
        cu.setLength(prefix);
        cu.append(linecount).append(revcount);
        this.insert(cu);
    }

    void dataToString(int id, String dirPrefix, StringBuffer sb, _Attribute attribute) throws DbException {
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_BUCKET_DATA_NEW).append(attribute).append(id);
        int prefix = cu.length();
        String previousString = "";
        while (this.retrieve(cu, prefix)) {
            String thisString = dirPrefix;
            int offset = prefix;
            thisString = thisString + "[" + cu.stringAt(offset) + ", ";
            offset = cu.skipString(offset);
            thisString = thisString + cu.stringAt(offset) + ", ";
            offset = cu.skipString(offset);
            if (!(thisString = thisString + cu.stringAt(offset) + "] ").equals(previousString)) {
                sb.append("\n").append(thisString);
                previousString = thisString;
            }
            offset = cu.skipString(offset);
            sb.append(cu.longAt(offset)).append("=[");
            offset = cu.skipLong(offset);
            sb.append(cu.longAt(offset)).append(",");
            offset = cu.skipLong(offset);
            sb.append(cu.longAt(offset)).append("] ");
        }
    }

    BucketDataCollection getBuckets(int dataID, ParameterSetRetrieve params, String key, _Attribute attribute) throws DbException {
        return this.getBucketsNoStack(dataID, params, key, attribute);
    }

    BucketDataCollection getBuckets(int dataID, ParameterSetRetrieve params, _Attribute attribute) throws DbException {
        switch (params.breakdown) {
            case NONE: {
                return this.getBucketsNoStack(dataID, params, "", attribute);
            }
            case SUBDIR: {
                break;
            }
            case EXTN: {
                return this.getBucketsByExtn(dataID, params, attribute);
            }
            case AUTHOR: {
                return this.getBucketsByAuthor(dataID, params, attribute);
            }
        }
        return new BucketDataCollection();
    }

    BucketDataCollection getBucketsNoStack(int dataID, ParameterSetRetrieve params, String key, _Attribute attribute) throws DbException {
        BucketDataCollection bucketDataCollection = new BucketDataCollection();
        _Cu cu = _Cu.alloc();
        for (String author : params.authors) {
            for (String extn : params.extensions) {
                cu.clear().append(CommonSchema.E_BUCKET_DATA_NEW).append(attribute).append(dataID).append(params.branch).append(extn).append(author);
                int prefix = cu.length();
                while (this.retrieve(cu, prefix)) {
                    int offset = prefix;
                    int bucket = (int)cu.longAt(offset);
                    offset = cu.skipLong(offset);
                    int linecount = (int)cu.longAt(offset);
                    offset = cu.skipLong(offset);
                    int revcount = (int)cu.longAt(offset);
                    bucketDataCollection.add(key, bucket, linecount, revcount);
                }
            }
        }
        return bucketDataCollection;
    }

    BucketDataCollection getBucketsByAuthor(int dataID, ParameterSetRetrieve params, _Attribute attribute) throws DbException {
        _Cu cu = _Cu.alloc();
        BucketDataCollection bucketDataCollection = new BucketDataCollection();
        for (String extn : params.extensions) {
            cu.clear().append(CommonSchema.E_BUCKET_DATA_NEW).append(attribute).append(dataID).append(params.branch).append(extn);
            int prefix = cu.length();
            while (this.retrieve(cu, prefix)) {
                int offset = prefix;
                String author = cu.stringAt(offset);
                offset = cu.skipString(offset);
                int bucket = (int)cu.longAt(offset);
                offset = cu.skipLong(offset);
                int linecount = (int)cu.longAt(offset);
                offset = cu.skipLong(offset);
                int revcount = (int)cu.longAt(offset);
                bucketDataCollection.add(author, bucket, linecount, revcount);
            }
        }
        return bucketDataCollection;
    }

    BucketDataCollection getBucketsByExtn(int dataID, ParameterSetRetrieve params, _Attribute attribute) throws DbException {
        _Cu cu = _Cu.alloc();
        BucketDataCollection bucketDataCollection = new BucketDataCollection();
        cu.clear().append(CommonSchema.E_BUCKET_DATA_NEW).append(attribute).append(dataID).append(params.branch);
        int prefix = cu.length();
        while (this.retrieve(cu, prefix)) {
            int offset = prefix;
            String extn = cu.stringAt(offset);
            String author = cu.stringAt(offset = cu.skipString(offset));
            if (!params.isTargetAuthor(author)) continue;
            offset = cu.skipString(offset);
            int bucket = (int)cu.longAt(offset);
            offset = cu.skipLong(offset);
            int linecount = (int)cu.longAt(offset);
            offset = cu.skipLong(offset);
            int revcount = (int)cu.longAt(offset);
            bucketDataCollection.add(extn, bucket, linecount, revcount);
        }
        return bucketDataCollection;
    }

    void deleteAllData() throws DbException {
        this.deleteObject(CommonSchema.E_BUCKETDATA_INFO);
        this.deleteObject(CommonSchema.E_DIR);
        this.deleteObject(CommonSchema.E_BUCKET_DATA_NEW);
    }

    void resetAllIds() throws DbException {
        _Cu cu = _Cu.alloc();
        this.saveBucketdataInfo(CommonSchema.A_NEXT_ID_DIR, 1, cu);
        this.saveBucketdataInfo(CommonSchema.A_NEXT_ID_BUCKETDATA, 0, cu);
    }

    boolean dirExists(int id) throws DbException {
        _Cu cu = _Cu.alloc().append(CommonSchema.E_DIR).append(id);
        return this.retrieve(cu, cu.length());
    }

    boolean isAtCurrentVersion() throws DbException {
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_BUCKET_DB_VERSION);
        int pl = cu.length();
        if (this.retrieve(cu, pl)) {
            int dbVersion = (int)cu.longAt(pl);
            if (dbVersion == 11) {
                return true;
            }
            Logs.CONSOLE.info((Object)("Repository " + this.repname + ": Linecount database at version " + dbVersion + ", upgrade to version " + 11 + " required."));
            return false;
        }
        Logs.CONSOLE.info((Object)("Repository " + this.repname + ": No linecount database exists, creating at version " + 11));
        return false;
    }

    void setVersionToCurrent() throws DbException {
        this.saveBucketdataInfo(CommonSchema.A_BUCKET_DB_VERSION, 11, _Cu.alloc());
    }

    String loadTimeZone() throws DbException {
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_BUCKET_TIMEZONE);
        int pl = cu.length();
        if (this.retrieve(cu, pl)) {
            return cu.stringAt(pl);
        }
        return "";
    }

    void saveTimeZone(TimeZone timeZone) throws DbException {
        this.update(_Cu.alloc().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_BUCKET_TIMEZONE), _Cu.alloc().append(timeZone.getID()));
    }

    private void setTimeZones() throws DbException {
        String dbTimezone = this.loadTimeZone();
        String currentTimezone = TimeZone.getDefault().getID();
        String serverTimezone = AppConfig.getsConfig().getTimezone().getID();
    }

    public void saveNextId(_Attribute attribute, int nextId) throws DbException {
        int savedNextId = this.readNextId(attribute, nextId);
        if (savedNextId < nextId) {
            this.saveBucketdataInfo(attribute, nextId, _Cu.alloc());
        }
    }

    public void resetNextId(_Attribute attribute, int nextId, int minValue) throws DbException {
        this.saveNextId(attribute, Math.max(nextId, minValue));
    }

    int readNextId(_Attribute attribute, int minValue) throws DbException {
        int nextId = this.loadBucketdataInfo(attribute, _Cu.alloc());
        if (nextId < minValue) {
            this.saveBucketdataInfo(attribute, minValue, _Cu.alloc());
            return minValue;
        }
        return nextId;
    }

    public int getNextIdAndIncrement(_Attribute attribute, int minValue) throws DbException {
        int nextId = this.readNextId(attribute, minValue);
        this.saveBucketdataInfo(attribute, nextId + 1, _Cu.alloc());
        return nextId;
    }

    public void saveMinAuthorBlameDone(int revid) throws DbException {
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_MIN_REVID_AUTHOR_DONE);
        this.update(cu, _Cu.alloc().append(revid));
        this.deleteOldBlameDone(revid);
    }

    private void deleteOldBlameDone(int min) throws DbException {
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_AUTHOR_BLAME_DONE_FORWARD);
        int offset = cu.length();
        while (this.retrieve(cu, offset)) {
            int id = (int)cu.longAt(offset);
            if (id > min) {
                return;
            }
            this.deleteObject(cu);
        }
    }

    public int loadMinAuthorBlameDone() throws DbException {
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_MIN_REVID_AUTHOR_DONE);
        return this.loadInt(cu);
    }

    public boolean isAuthorBlameDone(int revid) throws DbException {
        int min = this.loadMinAuthorBlameDone();
        if (revid <= min) {
            return true;
        }
        _Cu cu = _Cu.alloc().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_AUTHOR_BLAME_DONE_FORWARD).append(revid);
        return this.retrieve(cu, cu.length());
    }

    private String getBlameForward() throws DbException {
        _Cu cu = _Cu.alloc().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_AUTHOR_BLAME_DONE_FORWARD);
        int offset = cu.length();
        String s = "";
        while (this.retrieve(cu, offset)) {
            s = s + cu.longAt(offset) + " ";
        }
        return s;
    }

    public void setAuthorBlameDone(int revid) throws DbException {
        if (revid > this.loadMinAuthorBlameDone()) {
            _Cu cu = _Cu.alloc().append(CommonSchema.E_BUCKETDATA_INFO).append(CommonSchema.A_AUTHOR_BLAME_DONE_FORWARD).append(revid).append(true);
            this.insert(cu);
        }
    }

    public Set<String> getAvailableExtns(int id, _Attribute attribute) throws DbException {
        HashSet<String> extns = new HashSet<String>();
        _Cu cu = _Cu.alloc();
        cu.clear().append(CommonSchema.E_BUCKET_DATA_NEW).append(attribute).append(id);
        int prefix = cu.length();
        while (this.retrieve(cu, prefix)) {
            int offset = cu.skipString(prefix);
            extns.add(cu.stringAt(offset));
        }
        return extns;
    }
}

