/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.cenqua.fisheye.io.IOHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class RevisionCacheProperties {
    public static final long SERIAL_DEFAULT = 1L;
    private final Properties props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNew(File file, String version) throws IOException {
        Properties props = new Properties();
        props.setProperty("version", version);
        props.setProperty("serial", Long.toString(RevisionCacheProperties.makeNewSerial()));
        FileOutputStream out = new FileOutputStream(file);
        try {
            props.store(out, null);
        }
        finally {
            IOHelper.close(out);
        }
    }

    public static RevisionCacheProperties readExisting(File file) throws IOException {
        return new RevisionCacheProperties(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevisionCacheProperties(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.props.load(in);
        }
        finally {
            IOHelper.close(in);
        }
    }

    public String getVersion() {
        return this.props.getProperty("version");
    }

    public long getSerial() {
        String s = this.props.getProperty("serial");
        if (s == null) {
            return 1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e2) {
            return 1L;
        }
    }

    private static long makeNewSerial() {
        return System.currentTimeMillis();
    }
}

