/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

@Component
public class SpringContext
implements ApplicationListener {
    private static ApplicationContext applicationContext;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext context = ((ContextRefreshedEvent)event).getApplicationContext();
            if (applicationContext != null && context instanceof WebApplicationContext && applicationContext.getParent() == null) {
                ((ConfigurableWebApplicationContext)context).setParent(applicationContext);
                applicationContext = context;
            } else if (applicationContext == null) {
                applicationContext = context;
            }
        }
    }

    public static ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            throw new RuntimeException("Application Context not initialised.");
        }
        return applicationContext;
    }

    public static boolean isSetup() {
        return applicationContext != null;
    }

    public static void setApplicationContext(ApplicationContext appContext) {
        applicationContext = appContext;
    }

    public static void autowireObject(Object o) {
        SpringContext.getApplicationContext().getAutowireCapableBeanFactory().autowireBeanProperties(o, 4, false);
    }

    public static Object createComponent(Class clazz) {
        return SpringContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz, 4, false);
    }

    public static Object getComponent(String name) {
        return SpringContext.getApplicationContext().getBean(name);
    }
}

