/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.util.MinMaxLongRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcsFileHistory {
    private LinkedHashMap<Revision, RcsRevisionInfo> mRevisions = new LinkedHashMap();
    private Path mPath;
    private String mHead;
    private int mHeadByteCount;
    private boolean mBinary = false;
    private String mExpand;
    private final Map<String, Revision> mSymbolMap = new HashMap<String, Revision>();
    private Map<String, List<Revision>> mBranches;
    private Map<String, Revision> mBranchPoints = new HashMap<String, Revision>();
    private String mMainBranchName;

    public boolean isBinary() {
        return this.mBinary;
    }

    public KeywordExpansion getExpand() {
        return KeywordExpansion.parse(this.mExpand);
    }

    public void setExpand(String expand) {
        this.mExpand = expand;
        if ("b".equals(expand)) {
            this.mBinary = true;
        }
    }

    public String getHead() {
        return this.mHead;
    }

    public void setHead(String head) {
        this.mHead = head;
    }

    public void setPath(Path path) {
        this.mPath = path;
    }

    public Collection<RcsRevisionInfo> getRevisions() {
        return this.mRevisions.values();
    }

    public RcsRevisionInfo getRevision(String r) {
        return this.getRevision(this.revisionFromString(r));
    }

    public RcsRevisionInfo getCvsRevision(String r) {
        return this.getRevision(this.revisionFromString(r));
    }

    public RcsRevisionInfo getRevision(Revision r) {
        if (r == null) {
            return null;
        }
        return this.mRevisions.get(r);
    }

    void add(RcsRevisionInfo aInfo) {
        this.mRevisions.put(aInfo.getCvsRevision(), aInfo);
    }

    public String getFirstRevisionOnBranch(String branch) {
        List<Revision> revs = this.mBranches.get(branch);
        if (revs == null || revs.isEmpty()) {
            return null;
        }
        Revision r = revs.get(0);
        return r.toString();
    }

    public Collection<String> getBranches() {
        return Collections.unmodifiableCollection(this.mBranches.keySet());
    }

    public List<String> getBranches(Revision rev) {
        LinkedList<String> l = new LinkedList<String>();
        for (String br : this.mBranchPoints.keySet()) {
            Revision bp = this.mBranchPoints.get(br);
            if (!rev.equals(bp)) continue;
            l.add(br);
        }
        return l;
    }

    public Path getPath() {
        return this.mPath;
    }

    public String toString() {
        return this.getPath().toString();
    }

    void addSymbol(String sym, Revision rev) {
        this.mSymbolMap.put(sym, rev);
    }

    public Map getSymbolMap() {
        return this.mSymbolMap;
    }

    public MinMaxLongRange getDateRange() {
        MinMaxLongRange range = new MinMaxLongRange();
        for (RcsRevisionInfo info : this.mRevisions.values()) {
            range.add(info.getDate());
        }
        return range;
    }

    public Revision revisionFromString(String str) {
        if (this.mSymbolMap.containsKey(str)) {
            return this.mSymbolMap.get(str);
        }
        List<Revision> revs = this.mBranches.get(str);
        if (revs != null) {
            if (revs.isEmpty()) {
                return this.getCvsBranchPoint(str);
            }
            return revs.get(revs.size() - 1);
        }
        Revision bp = this.getCvsBranchPoint(str);
        if (bp != null) {
            return bp;
        }
        if ("HEAD".equals(str)) {
            return new Revision(this.mHead);
        }
        try {
            return new Revision(str);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public Revision getCvsBranchPoint(String branch) {
        return this.mBranchPoints.get(branch);
    }

    void setBranches(Map<String, List<Revision>> branches) {
        this.mBranches = branches;
    }

    void setBranchPoint(String brName, Revision cur) {
        this.mBranchPoints.put(brName, cur);
    }

    public List getRevisions(String br) {
        List<Revision> l = this.mBranches.get(br);
        if (l == null) {
            return new ArrayList();
        }
        ArrayList<String> ret = new ArrayList<String>(l.size());
        for (Revision r : l) {
            ret.add(r.toString());
        }
        return ret;
    }

    public void setMainBranchName(String mainBranchName) {
        this.mMainBranchName = mainBranchName;
    }

    public String getMainBranch() {
        return this.mMainBranchName;
    }

    public int getHeadByteCount() {
        return this.mHeadByteCount;
    }

    void setHeadByteCount(int headByteCount) {
        this.mHeadByteCount = headByteCount;
    }
}

