/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.quicksearch.FilenameSearch;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearcher;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.svn.SvnCache;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.util.HierarchicalPathCollector;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilenameQuickSearch
implements QuickSearcher.SearchAlgorithm {
    private final RepositoryEngine eng;
    private final SvnCache svnCache;

    public FilenameQuickSearch(QuickSearcher searcher) {
        this.eng = searcher.getEngine();
        RevisionCache rc = this.eng.getRevisionCache();
        this.svnCache = rc instanceof SvnCache ? (SvnCache)rc : null;
    }

    @Override
    public QuickSearchResults.TermResults search(Path path, List<String> params) throws IOException, DbException {
        if (params.isEmpty()) {
            return null;
        }
        QuickSearchResults.TermResults matches = new QuickSearchResults.TermResults();
        for (String term : params) {
            this.processFilenameTerm(path, term, matches);
        }
        Path exactMatch = (Path)matches.getExactMatch();
        if (exactMatch != null) {
            UrlHelper url = new UrlHelper();
            url.setUrl("/browse/" + this.eng.getName() + "/" + exactMatch.getPath());
            matches.setExactMatchRedirect(url);
        }
        return matches;
    }

    private void processFilenameTerm(Path path, String term, QuickSearchResults.TermResults matches) throws DbException, IOException {
        RevisionCache cache = this.eng.getRevisionCache();
        _k4uideIDB db = cache.getInfDb().get();
        SvnLogicalPathMatcher matcher = this.svnCache != null ? this.svnCache.getPathMatcher() : null;
        FilenameSearch fs = new FilenameSearch(db, matches, path, term, matcher, cache.isCaseSensitive());
        fs.search();
    }

    public static class FilenameItemMatch
    extends QuickSearchResults.ItemMatch {
        final boolean mFile;
        final boolean sameLogicalsCollapsed;
        final HierarchicalPathCollector mPathMap = new HierarchicalPathCollector();

        public FilenameItemMatch(String item, int count, List subResults, boolean subResultsTruncated, boolean isFile, boolean sameLogicalsCollapsed) {
            super(item, count, subResults, subResultsTruncated);
            this.mFile = isFile;
            this.sameLogicalsCollapsed = sameLogicalsCollapsed;
            this.mPathMap.addAll(subResults);
        }

        public boolean isFile() {
            return this.mFile;
        }

        public boolean isSameLogicalsCollapsed() {
            return this.sameLogicalsCollapsed;
        }

        public Map getDirectoryMap() {
            return this.mPathMap.getDirectoryMap();
        }
    }
}

