/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.quicksearch.CsidQuickSearch;
import com.cenqua.fisheye.cvsrep.quicksearch.FilenameQuickSearch;
import com.cenqua.fisheye.cvsrep.quicksearch.PhraseQuickSearch;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchParams;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.TermLookupQuickSearch;
import com.cenqua.fisheye.cvsrep.quicksearch.TermQuickSearch;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;

public class QuickSearcher {
    private final IndexReader[] mReaders;
    private final RepositoryEngine eng;

    public QuickSearcher(IndexReader[] readers, RepositoryEngine eng) {
        this.mReaders = readers;
        this.eng = eng;
    }

    IndexReader[] getReaders() {
        return this.mReaders;
    }

    public RepositoryEngine getEngine() {
        return this.eng;
    }

    public QuickSearchResults search(QuickSearchParams params) throws IOException, DbException {
        QuickSearchResults results = new QuickSearchResults();
        PhraseQuickSearch cqs = new PhraseQuickSearch(this, "comment", 0);
        results.setCommentResults(cqs.search(params.getPath(), params.commentTerms));
        FilenameQuickSearch fqs = new FilenameQuickSearch(this);
        results.setFileResults(fqs.search(params.getPath(), params.filenameTerms));
        TermQuickSearch aqs = new TermQuickSearch(this, CommonSchema.E_AUTHOR_TO_REVID, false);
        results.setAuthorResults(aqs.search(params.getPath(), params.authorTerms));
        _EntityClass[] branchInversions = new _EntityClass[]{CommonSchema.E_MOD_ON_BRANCH_TO_REVID, CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, CommonSchema.E_BP_ON_BRANCH_TO_REVID};
        TermQuickSearch bqs = new TermQuickSearch(this, branchInversions, false);
        results.setBranchResults(bqs.search(params.getPath(), params.branchTerms));
        TermLookupQuickSearch tqs = new TermLookupQuickSearch(this, CommonSchema.E_TAGS, CommonSchema.E_TAG_TO_REVID);
        results.setTagResults(tqs.search(params.getPath(), params.tagTerms));
        CsidQuickSearch csidqs = new CsidQuickSearch(this);
        results.setCsidResults(csidqs.search(params.getPath(), params.csidTerms));
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SearchAlgorithm {
        public static final int MAX_SUB_RESULTS = 100;

        public QuickSearchResults.TermResults search(Path var1, List<String> var2) throws IOException, DbException;
    }
}

