/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.tags.MaybeReview;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReturnClause {
    private final List<Field> fields = new ArrayList<Field>();

    public void addField(Field f2) {
        this.fields.add(f2);
    }

    public int numFields() {
        return this.fields.size();
    }

    public Field getField(int i2) {
        return this.fields.get(i2);
    }

    public void toString(StringBuffer buf) {
        String sep = "";
        for (Field field : this.fields) {
            buf.append(sep);
            field.toQueryString(buf);
            sep = ", ";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReviewsField
    extends MapArrayTypeField {
        public ReviewsField() {
            super("reviews");
        }

        public List<MaybeReview> asReviewList(FileRevision fi) {
            List<Integer> rids = fi.getReviewIds();
            LinkedList<MaybeReview> result = new LinkedList<MaybeReview>();
            for (Integer rid : rids) {
                Review r = ReviewManager.getReviewById(rid);
                result.add(new MaybeReview(r, ReviewUtil.canDoReviewAction("action:viewReview", r)));
            }
            return result;
        }

        @Override
        public List asList(FileRevision fi) {
            return this.asReviewList(fi);
        }

        @Override
        public Map[] asMapArray(FileRevision fi) {
            ArrayList results = new ArrayList();
            for (MaybeReview mr : this.asReviewList(fi)) {
                LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                if (mr.getReview() != null) {
                    Review r = mr.getReview();
                    values.put("id", r.getPermaId());
                    values.put("title", r.getName() != null ? r.getName().trim() : "");
                    values.put("description", r.getDescription() != null ? r.getDescription().trim() : "");
                    State state = r.getState();
                    values.put("state", state.getName());
                    values.put("isDraft", state.isDraftMetaState() ? "true" : "false");
                    values.put("isOpen", state.isOpenMetaState() ? "true" : "false");
                    values.put("isClosed", state.isClosedMetaState() ? "true" : "false");
                } else {
                    values.put("id", mr.getPermaId());
                }
                results.add(values);
            }
            return results.toArray(new Map[results.size()]);
        }
    }

    public static class TagsField
    extends StringArrayTypeField {
        protected TagsField() {
            super("tags");
        }

        public String[] asStringArray(FileRevision fi) {
            List<String> tagList = fi.getTags();
            Collections.sort(tagList);
            String[] tags = new String[tagList.size()];
            tagList.toArray(tags);
            return tags;
        }
    }

    public static class LinesRemovedField
    extends IntTypeField {
        protected LinesRemovedField() {
            super("linesRemoved");
        }

        public int asInt(FileRevision fi) {
            return fi.getLinesRemoved();
        }
    }

    public static class LinesAddedField
    extends IntTypeField {
        protected LinesAddedField() {
            super("linesAdded");
        }

        public int asInt(FileRevision fi) {
            return fi.getLinesAdded();
        }
    }

    public static class TotalLinesField
    extends IntTypeField {
        protected TotalLinesField() {
            super("totalLines");
        }

        public int asInt(FileRevision fi) {
            return fi.getLineCount();
        }
    }

    public static class IsMovedField
    extends StringTypeField {
        public IsMovedField() {
            super("isMoved");
        }

        public String asString(FileRevision fi) {
            return String.valueOf(fi.isMove());
        }
    }

    public static class IsCopiedField
    extends StringTypeField {
        public IsCopiedField() {
            super("isCopied");
        }

        public String asString(FileRevision fi) {
            return String.valueOf(fi.isCopy());
        }
    }

    public static class IsAddedField
    extends StringTypeField {
        public IsAddedField() {
            super("isAdded");
        }

        public String asString(FileRevision fi) {
            return String.valueOf(fi.isAdded());
        }
    }

    public static class IsDeletedField
    extends StringTypeField {
        public IsDeletedField() {
            super("isDeleted");
        }

        public String asString(FileRevision fi) {
            return String.valueOf(fi.isDead());
        }
    }

    public static class IsBinaryField
    extends StringTypeField {
        public IsBinaryField() {
            super("isBinary");
        }

        public String asString(FileRevision fi) {
            return String.valueOf(fi.isBinary());
        }
    }

    public static class ChangeSetField
    extends StringTypeField {
        public ChangeSetField() {
            super("csid");
        }

        public String asString(FileRevision fi) {
            return fi.getChangeSetId();
        }
    }

    public static class CommentField
    extends StringTypeField {
        public CommentField() {
            super("comment");
        }

        public String asString(FileRevision fi) {
            return fi.getComment();
        }
    }

    public static class DateField
    extends DateTypeField {
        public DateField() {
            super("date");
        }

        public long asDate(FileRevision fi) {
            return fi.getDate();
        }
    }

    public static class AuthorField
    extends StringTypeField {
        public AuthorField() {
            super("author");
        }

        public String asString(FileRevision fi) {
            return fi.getAuthor();
        }
    }

    public static class RevisionField
    extends StringTypeField {
        public RevisionField() {
            super("revision");
        }

        public String asString(FileRevision fi) {
            return fi.getRevision();
        }
    }

    public static class PathField
    extends PathTypeField {
        public PathField() {
            super("path");
        }

        public Path asPath(FileRevision fi) {
            return fi.getPath();
        }
    }

    public static abstract class IntTypeField
    extends Field {
        protected IntTypeField(String columnName) {
            super(columnName, Type.INTEGER);
        }

        public abstract int asInt(FileRevision var1);

        public Object asObject(FileRevision fi) {
            return this.asInt(fi);
        }
    }

    public static abstract class DateTypeField
    extends Field {
        protected DateTypeField(String columnName) {
            super(columnName, Type.DATE);
        }

        public abstract long asDate(FileRevision var1);

        public Date asDateValue(FileRevision fi) {
            return new Date(this.asDate(fi));
        }

        public String asString(FileRevision fi) {
            return ISO8601DateHelper.toIsoDate(this.asDate(fi));
        }

        public Object asObject(FileRevision fi) {
            return this.asDateValue(fi);
        }
    }

    public static abstract class MapArrayTypeField
    extends Field {
        protected MapArrayTypeField(String columnName) {
            super(columnName, Type.MAP_ARRAY);
        }

        public abstract Map[] asMapArray(FileRevision var1);

        public Object asObject(FileRevision fi) {
            return this.asMapArray(fi);
        }
    }

    public static abstract class StringArrayTypeField
    extends Field {
        protected StringArrayTypeField(String columnName) {
            super(columnName, Type.STRING_ARRAY);
        }

        public abstract String[] asStringArray(FileRevision var1);

        public Object asObject(FileRevision fi) {
            return this.asStringArray(fi);
        }
    }

    public static abstract class StringTypeField
    extends Field {
        protected StringTypeField(String columnName) {
            super(columnName, Type.STRING);
        }

        public abstract String asString(FileRevision var1);

        public Object asObject(FileRevision fi) {
            return this.asString(fi);
        }
    }

    public static abstract class PathTypeField
    extends Field {
        protected PathTypeField(String columnName) {
            super(columnName, Type.PATH);
        }

        public abstract Path asPath(FileRevision var1);

        public Object asObject(FileRevision fi) {
            return this.asPath(fi);
        }
    }

    public static abstract class Field {
        private String columnName;
        private final String field;
        private final Type type;

        protected Field(String expr, Type type) {
            this.columnName = expr;
            this.field = expr;
            this.type = type;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getField() {
            return this.field;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isInt() {
            return this.getType() == Type.INTEGER;
        }

        public boolean isDate() {
            return this.getType() == Type.DATE;
        }

        public Path asPath(FileRevision fi) {
            return null;
        }

        public String asString(FileRevision fi) {
            Object o = this.asObject(fi);
            return o == null ? null : o.toString();
        }

        public long asDate(FileRevision fi) {
            return 0L;
        }

        public int asInt(FileRevision fi) {
            return 0;
        }

        public Date asDateValue(FileRevision fi) {
            return null;
        }

        public String[] asStringArray(FileRevision fi) {
            return new String[0];
        }

        public Map[] asMapArray(FileRevision fi) {
            return new HashMap[0];
        }

        public List asList(FileRevision fi) {
            return Collections.EMPTY_LIST;
        }

        public abstract Object asObject(FileRevision var1);

        public void toQueryString(StringBuffer buf) {
            buf.append(this.field);
            if (!this.field.equals(this.columnName)) {
                buf.append(" as ");
                Clause.quoteString(this.columnName, buf);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DATE,
        STRING,
        INTEGER,
        STRING_ARRAY,
        MAP_ARRAY,
        PATH;

    }
}

