/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.Section;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HunkList {
    private final List<Hunk> mHunks = new ArrayList<Hunk>();
    private final int mFromSize;
    private final int mToSize;

    public HunkList(int aFromSize, int aToSize) {
        this.mFromSize = aFromSize;
        this.mToSize = aToSize;
    }

    public String toString() {
        return this.mHunks.toString();
    }

    public int getFromSize() {
        return this.mFromSize;
    }

    public int getToSize() {
        return this.mToSize;
    }

    public Iterator getIterator() {
        return this.mHunks.iterator();
    }

    public void insertDelta(Hunk hunk) {
        this.mHunks.add(0, hunk);
    }

    public int size() {
        return this.mHunks.size();
    }

    public Hunk getHunk(int i2) {
        return this.mHunks.get(i2);
    }

    public List getSections() throws IOException {
        return this.getSections(-1);
    }

    public List<Section> getSections(final int linesOfContext) throws IOException {
        final ArrayList<Section> sections = new ArrayList<Section>(this.mHunks.size() * 2 + 2);
        Visitor v = new Visitor(){

            public void change(Hunk hunk) {
                this.addDiff(hunk);
            }

            public void add(Hunk hunk) {
                this.addDiff(hunk);
            }

            public void delete(Hunk hunk) {
                this.addDiff(hunk);
            }

            public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
                Section sect = new Section(true, new Hunk(fromStart, toStart, lenx, leny));
                sect.setSkippedPrevious(skipPrevious);
                sections.add(sect);
            }

            private void addDiff(Hunk hunk) {
                Section sect = new Section(false, hunk);
                if (linesOfContext == 0) {
                    sect.setSkippedPrevious(true);
                }
                sections.add(sect);
            }
        };
        this.visit(v, linesOfContext);
        return sections;
    }

    public void visit(Visitor visitor) throws IOException {
        this.visit(visitor, -1);
    }

    public void visit(Visitor visitor, int linesOfContext) throws IOException {
        VisitorAlg alg = new VisitorAlg(visitor, linesOfContext);
        alg.visit();
    }

    class VisitorAlg {
        final Visitor visitor;
        final int linesOfContext;
        boolean isFirst = true;
        int lastx = 0;
        int lasty = 0;

        public VisitorAlg(Visitor visitor, int linesOfContext) {
            this.visitor = visitor;
            this.linesOfContext = linesOfContext;
        }

        public void visit() throws IOException {
            int leny;
            int lenx;
            int len;
            boolean ignoredAllHunksSoFar = true;
            for (int i2 = 0; i2 < HunkList.this.mHunks.size(); ++i2) {
                Hunk hunk = (Hunk)HunkList.this.mHunks.get(i2);
                if (!hunk.isIgnored() || ignoredAllHunksSoFar && i2 == HunkList.this.mHunks.size() - 1 || this.linesOfContext != 0 && (this.linesOfContext <= 0 || this.closeToNeighbours(i2))) {
                    ignoredAllHunksSoFar = false;
                    if (this.lastx < hunk.getFrom() || this.lasty < hunk.getTo()) {
                        int lenx2 = hunk.getFrom() - this.lastx;
                        int leny2 = hunk.getTo() - this.lasty;
                        this.visitCommon(false, lenx2, leny2);
                    }
                    if (hunk.isChange()) {
                        this.visitor.change(hunk);
                    } else if (hunk.isAdd()) {
                        this.visitor.add(hunk);
                    } else if (hunk.isDelete()) {
                        this.visitor.delete(hunk);
                    }
                    this.lastx = hunk.getFrom() + hunk.getFromCount();
                    this.lasty = hunk.getTo() + hunk.getToCount();
                }
                this.isFirst = false;
            }
            if (this.lastx < HunkList.this.getFromSize() && (len = Math.min(lenx = HunkList.this.getFromSize() - this.lastx, leny = HunkList.this.getToSize() - this.lasty)) != 0) {
                this.visitCommon(true, len, len);
            }
        }

        private boolean closeToNeighbours(int i2) {
            Hunk next;
            Hunk prev;
            Hunk hunk = (Hunk)HunkList.this.mHunks.get(i2);
            if (i2 > 0 && this.close(prev = (Hunk)HunkList.this.mHunks.get(i2 - 1), hunk)) {
                return true;
            }
            return i2 + 1 < HunkList.this.mHunks.size() && this.close(hunk, next = (Hunk)HunkList.this.mHunks.get(i2 + 1));
        }

        private boolean close(Hunk a2, Hunk b2) {
            int maxLen;
            int len = b2.getFrom() - a2.getFrom() + a2.getFromCount();
            return len <= (maxLen = this.linesOfContext * 2 + 1);
        }

        private void visitCommon(boolean isLast, int lenx, int leny) throws IOException {
            int maxLen;
            if (this.linesOfContext == 0) {
                return;
            }
            if (this.linesOfContext < 0) {
                this.visitor.common(this.lastx, this.lasty, lenx, leny, false);
                return;
            }
            int n = maxLen = this.isFirst || isLast ? this.linesOfContext : this.linesOfContext * 2 + 1;
            if (lenx > maxLen) {
                int xCtx = Math.min(lenx, this.linesOfContext);
                int yCtx = Math.min(leny, this.linesOfContext);
                if (!this.isFirst) {
                    this.visitor.common(this.lastx, this.lasty, xCtx, yCtx, false);
                }
                if (!isLast) {
                    boolean skipPrevious = !this.isFirst;
                    this.visitor.common(this.lastx + lenx - xCtx, this.lasty + leny - yCtx, xCtx, yCtx, skipPrevious);
                }
            } else {
                this.visitor.common(this.lastx, this.lasty, lenx, leny, false);
            }
        }
    }

    public static interface Visitor {
        public void common(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

        public void change(Hunk var1) throws IOException;

        public void add(Hunk var1) throws IOException;

        public void delete(Hunk var1) throws IOException;
    }
}

