/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.infinitydb.LongPropCacheKey;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InfinityDbHandle {
    private final Object lock = new Object();
    private final File file;
    private volatile long cacheSize;
    private _k4uideIDB db;
    private Map<LongPropCacheKey, Long> longPropCache = new HashMap<LongPropCacheKey, Long>();

    public InfinityDbHandle(File file) {
        this.file = file;
        this.cacheSize = 2500000L;
    }

    public InfinityDbHandle(File file, long cacheSize) {
        this.file = file;
        this.cacheSize = cacheSize;
    }

    public void setLongProperty(_EntityClass propertyClass, UniqueStringTable keySpace, String key, long value) throws DbException {
        Long current;
        LongPropCacheKey cacheKey = new LongPropCacheKey(propertyClass, keySpace.getTableClass(), key);
        if (this.longPropCache.containsKey(cacheKey) && (current = this.longPropCache.get(cacheKey)) == value) {
            return;
        }
        try {
            _k4uideIDB db = this.get();
            long keyId = keySpace.add(key);
            _Cu cu = _Cu.alloc().append(propertyClass);
            cu.append(keyId);
            int pl = cu.length();
            cu.append(value);
            ((_ItemSpace)db).update(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        this.longPropCache.put(cacheKey, value);
    }

    public long getLongProperty(_EntityClass propertyClass, UniqueStringTable keySpace, String key, long defaultValue) throws DbException {
        long result;
        LongPropCacheKey cacheKey = new LongPropCacheKey(propertyClass, keySpace.getTableClass(), key);
        if (this.longPropCache.containsKey(cacheKey)) {
            Long current = this.longPropCache.get(cacheKey);
            result = current;
        } else {
            try {
                _k4uideIDB db = this.get();
                long keyId = keySpace.add(key);
                _Cu cu = _Cu.alloc().append(propertyClass);
                cu.append(keyId);
                int pl = cu.length();
                result = ((_ItemSpace)db).next(cu, pl) ? cu.longAt(pl) : defaultValue;
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            this.longPropCache.put(cacheKey, result);
        }
        return result;
    }

    public boolean hasLongProperty(_EntityClass propertyClass, UniqueStringTable keySpace, String key) throws DbException {
        boolean hasProperty;
        LongPropCacheKey cacheKey = new LongPropCacheKey(propertyClass, keySpace.getTableClass(), key);
        if (this.longPropCache.containsKey(cacheKey)) {
            hasProperty = true;
        } else {
            try {
                _k4uideIDB db = this.get();
                long keyId = keySpace.add(key);
                _Cu cu = _Cu.alloc().append(propertyClass);
                cu.append(keyId);
                int pl = cu.length();
                hasProperty = ((_ItemSpace)db).next(cu, pl);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return hasProperty;
    }

    public _k4uideIDB get() throws DbException {
        try {
            return this.open();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _k4uideIDB open() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.db == null) {
                Logs.APP_LOG.info((Object)("opening " + this.file + " with cachesize=" + this.cacheSize));
                InfinityDbUtil.createIfNeccessary(this.file);
                this.db = _k4uideIDB.open(this.file.getPath(), true, this.cacheSize);
            }
            return this.db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            _k4uideIDB d2 = this.db;
            this.db = null;
            if (d2 != null) {
                Logs.APP_LOG.info((Object)("closing " + this.file));
                d2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.db != null) {
                this.db.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.db != null) {
                this.db.rollBack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.db != null;
        }
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public File getFile() {
        return this.file;
    }
}

