/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.BufferedCharSequence;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.RandomAccessIOStream;
import com.cenqua.fisheye.util.Disposable;
import gnu.trove.TLongArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class IndexedLineReader
implements Disposable {
    private final RandomAccessIOStream mFile;
    private final TLongArrayList mIndexes = new TLongArrayList();
    private int mCurrentLineNumber = 0;

    public IndexedLineReader(RandomAccessIOStream aFile) {
        this.mFile = aFile;
        this.mIndexes.add(this.mFile.getFilePointer());
    }

    public IndexedLineReader(File aFile) throws FileNotFoundException {
        this(new BufferedRandomAccessInputStream(aFile));
    }

    public String readline() throws IOException {
        StringBuffer buf = new StringBuffer();
        int nread = this.readline(buf);
        if (nread == -1) {
            return null;
        }
        return buf.toString();
    }

    public int getLineNumber() {
        return this.mCurrentLineNumber;
    }

    public int readline(StringBuffer aBuf) throws IOException {
        boolean atEOF;
        int c2;
        int nread = 0;
        while ((c2 = this.mFile.read()) != -1) {
            ++nread;
            aBuf.append((char)c2);
            if (c2 == 13) {
                int c22 = this.mFile.read();
                if (c22 == 10) {
                    ++nread;
                    aBuf.append((char)c22);
                    break;
                }
                if (c22 == -1) break;
                this.mFile.seek(this.mFile.getFilePointer() - 1L);
                break;
            }
            if (c2 != 10) continue;
        }
        if (nread == 0) {
            return -1;
        }
        long fp = this.mFile.getFilePointer();
        boolean bl = atEOF = fp == this.mFile.length();
        if (atEOF) {
            return nread;
        }
        ++this.mCurrentLineNumber;
        if (this.mCurrentLineNumber >= this.mIndexes.size()) {
            this.mIndexes.add(fp);
        }
        return nread;
    }

    public void close() throws IOException {
        this.mFile.close();
    }

    public void dispose() throws Exception {
        this.close();
    }

    public int getTotalLines() {
        return this.mIndexes.size();
    }

    public int length() {
        try {
            return (int)this.mFile.length();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void seekLine(int lineno) throws IOException {
        this.guardLineNumber(lineno);
        long fp = this.mIndexes.get(lineno);
        this.mFile.seek(fp);
        this.mCurrentLineNumber = lineno;
    }

    public void scanRestOfFile() throws IOException {
        this.scanRestOfFile(new StringBuffer());
    }

    public void scanRestOfFile(StringBuffer buf) throws IOException {
        buf.setLength(0);
        while (this.readline(buf) != -1) {
            buf.setLength(0);
        }
    }

    public CharSequence getCharSequence() {
        return new BufferedCharSequence(this.mFile);
    }

    public int getOffsetForLine(int lineno) {
        if (lineno == this.mIndexes.size()) {
            return this.length();
        }
        this.guardLineNumber(lineno);
        return (int)this.mIndexes.get(lineno);
    }

    public int getLineForOffset(int offset) {
        int search = this.mIndexes.binarySearch((long)offset);
        if (search >= 0) {
            return search;
        }
        if ((search = -search - 1) >= this.mIndexes.size()) {
            return this.mIndexes.size() - 1;
        }
        return search - 1;
    }

    public boolean isEolTerminated() throws IOException {
        long len = this.mFile.length();
        if (len == 0L) {
            return false;
        }
        this.mFile.seek(len - 1L);
        int c2 = this.mFile.read();
        return c2 == 10 || c2 == 13;
    }

    private void guardLineNumber(int lineno) {
        if (lineno >= this.mIndexes.size()) {
            throw new RuntimeException("unknown line number " + lineno + " only know about " + this.getTotalLines());
        }
    }
}

