/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.RandomAccessIOStream;
import java.io.IOException;

public class RandomAccessView
implements RandomAccessIOStream {
    private RandomAccessIOStream stream;
    private long viewOffset;
    private long viewLength;

    public RandomAccessView(RandomAccessIOStream underlyingStream, long viewOffset, long viewLength) throws IOException {
        this.stream = underlyingStream;
        this.viewOffset = viewOffset;
        this.viewLength = viewLength;
        this.seek(0L);
    }

    public void seek(long fp) throws IOException {
        this.stream.seek(this.viewOffset + fp);
    }

    public int read() throws IOException {
        long offset = this.getFilePointer();
        if (offset >= this.viewLength) {
            return -1;
        }
        return this.stream.read();
    }

    public long getFilePointer() {
        return this.stream.getFilePointer() - this.viewOffset;
    }

    public long length() throws IOException {
        return this.viewLength;
    }

    public void close() throws IOException {
    }
}

