/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.AbstractBitsetQuery;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class FilteringQuery
extends AbstractBitsetQuery {
    private final Filter filter;
    private final String filterExplanation;

    public FilteringQuery(Filter filter) {
        this(filter, null);
    }

    public FilteringQuery(Filter filter, String filterExpan) {
        this.filter = filter;
        this.filterExplanation = filterExpan;
    }

    protected String getFilterExplanation() {
        return this.filterExplanation != null ? this.filterExplanation : this.filter.toString();
    }

    public String toString(String field) {
        String res = "FilteringQuery( " + this.getFilterExplanation() + ")";
        if (field == null) {
            return res;
        }
        return res + "(" + field + " ?)";
    }

    public String toString() {
        return this.toString(null);
    }

    protected BitSet computeBitset(IndexReader reader) throws IOException {
        return this.filter.bits(reader);
    }
}

