/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.cenqua.fisheye.util.SortedMultiMap;
import java.util.ArrayList;
import java.util.List;

public class P4FileHistory
extends SortedMapFileHistory {
    public P4FileHistory(Path path, SortedMultiMap revisions) {
        super(path, revisions);
    }

    public String resolveRevisionFromString(Path lpath, String s) {
        try {
            Long rev = Long.valueOf(s);
            if (this.getRevisionMap().containsKey(rev)) {
                return s;
            }
            SortedMultiMap headMap = this.getRevisionMap().headMap(rev);
            ArrayList keys = new ArrayList(headMap.keySet());
            for (int i2 = keys.size() - 1; i2 >= 0; --i2) {
                Long key = (Long)keys.get(i2);
                List valueList = headMap.getList(key);
                for (FileRevision revision : valueList) {
                    if (!revision.getPath().equals(lpath)) continue;
                    return key.toString();
                }
            }
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        FileRevision br = null;
        for (FileRevision info : this.getRevisions()) {
            if (info.getTags().contains(s)) {
                return info.getRevision();
            }
            if (!info.getBranch().equals(s)) continue;
            if (br == null) {
                br = info;
                continue;
            }
            if (info.getDate() <= br.getDate()) continue;
            br = info;
        }
        if (br != null) {
            return br.getRevision();
        }
        if ("HEAD".equals(s)) {
            return this.getHead();
        }
        return null;
    }

    public String getMainBranch() {
        return "head";
    }
}

