/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class P4Server {
    static String p4dExecutable = "p4d";
    private File serverRoot;
    private long serverPort;
    private volatile Process serverProcess;
    private StringBuffer serverOutput = new StringBuffer();
    private StringBuffer serverError = new StringBuffer();

    public static void setP4dExecutable(String p4dExecutable) {
        P4Server.p4dExecutable = p4dExecutable;
    }

    public String loadCheckpoint(String checkPointName) throws P4ClientException {
        String command = p4dExecutable + " -r " + this.serverRoot.getAbsolutePath() + " -p " + this.serverPort + " -jr " + checkPointName;
        return this.executeCommand(command);
    }

    private String executeCommand(String command) throws P4ClientException {
        try {
            Logs.APP_LOG.debug((Object)("Executing " + command));
            Process process = Runtime.getRuntime().exec(command);
            StringBuffer output = new StringBuffer();
            StringBuffer error = new StringBuffer();
            Thread outputThread = this.processOutput("P4Server Output", process.getInputStream(), output);
            Thread errorThread = this.processOutput("P4Server Error", process.getErrorStream(), error);
            int exitValue = process.waitFor();
            outputThread.join();
            errorThread.join();
            if (exitValue != 0) {
                throw new P4ClientException("Non zero exit value: " + exitValue + ", output = " + output + ", error = " + error);
            }
            outputThread.join();
            errorThread.join();
            return output.toString();
        }
        catch (IOException e2) {
            throw new P4ClientException(e2);
        }
        catch (InterruptedException e3) {
            throw new P4ClientException(e3);
        }
    }

    private Thread processOutput(String name, final InputStream ioStream, final StringBuffer output) {
        Runnable outputReaderRunnable = new Runnable(){

            public void run() {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(ioStream));
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append('\n');
                    }
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        Thread outputThread = new Thread(outputReaderRunnable, name);
        outputThread.start();
        return outputThread;
    }

    public synchronized void start() throws P4ClientException {
        if (this.serverProcess != null) {
            throw new P4ClientException("Server is already running");
        }
        this.stop();
        String command = p4dExecutable + " -r " + this.serverRoot.getAbsolutePath() + " -p " + this.serverPort;
        try {
            this.serverProcess = Runtime.getRuntime().exec(command);
            this.serverOutput.setLength(0);
            this.serverError.setLength(0);
            this.processOutput("P4Server Output", this.serverProcess.getInputStream(), this.serverOutput);
            this.processOutput("P4Server Error", this.serverProcess.getErrorStream(), this.serverError);
            try {
                int exitValue = this.serverProcess.exitValue();
                this.serverProcess = null;
                throw new P4ClientException("Server failed to start: " + this.serverError + " : " + exitValue);
            }
            catch (IllegalThreadStateException e2) {
            }
        }
        catch (IOException e3) {
            throw new P4ClientException(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        try {
            this.executeCommand(P4Exec.getP4Executable() + " -p localhost:" + this.serverPort + " admin stop");
            if (this.serverProcess != null) {
                Thread.sleep(1000L);
                int exitValue = this.serverProcess.waitFor();
                if (exitValue != 0) {
                    System.out.println("Server failed when shutting down: " + exitValue);
                    Logs.APP_LOG.error((Object)("Server failed: " + exitValue));
                }
            }
        }
        catch (Throwable e2) {
            if (this.serverProcess != null) {
                System.out.println("Destroying P4 server");
                Logs.APP_LOG.error((Object)"Destroying P4 Server process");
                this.serverProcess.destroy();
            }
        }
        finally {
            this.serverProcess = null;
        }
    }

    public void setServerRoot(File serverRoot) {
        this.serverRoot = serverRoot;
    }

    public void setServerPort(long serverPort) {
        this.serverPort = serverPort;
    }
}

