/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RevidChangeSet
extends ChangeSet {
    protected TIntArrayList revids;
    private String branch;
    private FileRevision firstRev;
    private boolean branchComputed = false;

    public void init(TIntArrayList revids) throws DbException {
        this.revids = revids;
        int firstRevId = revids.get(0);
        this.firstRev = this.loadRevision(firstRevId);
    }

    protected FileRevision getFirstRevision() {
        return this.firstRev;
    }

    @Override
    public String getAuthor() {
        return this.firstRev.getAuthor();
    }

    @Override
    public long getDate() {
        return this.firstRev.getDate();
    }

    @Override
    public String getComment() {
        return this.firstRev.getComment();
    }

    @Override
    public String getId() {
        return this.firstRev.getRevision();
    }

    @Override
    public FileRevision getRevisionInfo(int i2) throws DbException {
        int revid = this.revids.get(i2);
        return this.loadRevision(revid);
    }

    @Override
    public int getRevisionInfosCount() throws DbException {
        return this.revids.size();
    }

    @Override
    public Iterator<RevInfoKey> getRevisionInfoKeys() throws DbException {
        ArrayList<RevInfoKey> keys = new ArrayList<RevInfoKey>();
        for (int i2 = 0; i2 < this.revids.size(); ++i2) {
            int revid = this.revids.get(i2);
            keys.add(this.getRevInfoKey(revid));
        }
        return keys.iterator();
    }

    @Override
    public String getBranch() throws DbException {
        if (!this.branchComputed) {
            this.branchComputed = true;
            HashSet<String> branches = new HashSet<String>();
            for (int i2 = 0; i2 < this.revids.size(); ++i2) {
                int revid = this.revids.get(i2);
                String branch = this.getBranchOf(revid);
                if (branch != null) {
                    branches.add(branch);
                }
                if (branches.size() > 1) break;
            }
            if (branches.size() == 1) {
                this.branch = (String)branches.iterator().next();
            }
        }
        return this.branch;
    }

    protected String getBranchOf(int revid) throws DbException {
        return this.getCommonDAO().getBranchOf(revid);
    }

    protected abstract CommonRevInfoDAO getCommonDAO();

    protected abstract RevInfoKey getRevInfoKey(int var1) throws DbException;

    protected abstract FileRevision loadRevision(int var1) throws DbException;
}

