/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryCache;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.fisheye.util.MultiMap;
import com.cenqua.fisheye.util.SortedMultiMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class SortedMapFileHistory
implements FileHistory {
    private final SortedMultiMap revisions;
    private final Path path;

    public SortedMapFileHistory(Path path, SortedMultiMap revisions) {
        this.path = path;
        this.revisions = revisions;
    }

    private FileRevision getFirst() {
        if (this.revisions.isEmpty()) {
            return null;
        }
        List firstList = this.revisions.getList(this.revisions.firstKey());
        return (FileRevision)firstList.get(0);
    }

    private FileRevision getLast() {
        if (this.revisions.isEmpty()) {
            return null;
        }
        List lastList = this.revisions.getList(this.revisions.lastKey());
        return (FileRevision)lastList.get(lastList.size() - 1);
    }

    public boolean isBinary() {
        FileRevision last = this.getLast();
        return last != null && last.isBinary();
    }

    public Path getPath() {
        return this.path;
    }

    public MinMaxLongRange getDateRange() {
        FileRevision last = this.getLast();
        long now = System.currentTimeMillis();
        long firstDate = last == null ? now : this.getFirst().getDate();
        long lastDate = last == null ? now : last.getDate();
        return new MinMaxLongRange(true, firstDate, lastDate);
    }

    public Collection getRevisions() {
        return this.revisions.values();
    }

    public List getRevisionsSorted() {
        ArrayList revs = new ArrayList(this.getRevisions());
        Collections.sort(revs, FileRevision.OldestFirstComparator.INSTANCE);
        Collections.reverse(revs);
        return revs;
    }

    public FileRevision getRevision(String rev) {
        Long changeSetId;
        if (rev == null) {
            return null;
        }
        try {
            changeSetId = Long.valueOf(rev);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        List revList = this.revisions.getList(changeSetId);
        if (revList == null) {
            return null;
        }
        return (FileRevision)revList.get(0);
    }

    public String getHead() {
        ArrayList csids = new ArrayList(this.revisions.keySet());
        ListIterator i2 = csids.listIterator(csids.size());
        while (i2.hasPrevious()) {
            Long key = (Long)i2.previous();
            List revList = this.revisions.getList(key);
            for (FileRevision revision : revList) {
                if (!revision.isTrunkLike()) continue;
                return revision.getRevision();
            }
        }
        return null;
    }

    public List getRevisions(String br) {
        ArrayList<String> branchRevisions = new ArrayList<String>();
        Iterator i2 = this.revisions.iterator();
        while (i2.hasNext()) {
            FileRevision revision = (FileRevision)i2.next();
            if (!br.equals(revision.getBranch())) continue;
            branchRevisions.add(revision.getChangeSetId());
        }
        return branchRevisions;
    }

    public Collection getBranches() {
        HashSet<String> branches = new HashSet<String>();
        Iterator i2 = this.revisions.iterator();
        while (i2.hasNext()) {
            FileRevision revision = (FileRevision)i2.next();
            branches.add(revision.getBranch());
            branches.addAll(revision.getBranches());
        }
        return branches;
    }

    public String getBranchPoint(String branch) {
        for (FileRevision info : this.getRevisions()) {
            if (!info.getBranches().contains(branch)) continue;
            return info.getRevision();
        }
        return null;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.println("History for :" + this.path);
        Iterator i2 = this.revisions.iterator();
        while (i2.hasNext()) {
            FileRevision fileRevision = (FileRevision)i2.next();
            pw.println(fileRevision);
        }
        pw.println("-----");
        pw.flush();
        return writer.toString();
    }

    public boolean containsRevision(String revision) {
        if (revision == null) {
            return false;
        }
        try {
            return this.revisions.containsKey(Long.valueOf(revision));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public String getFirstRevisionOnBranch(String branch) {
        List branchRevisions = this.getBranchRevisions(branch);
        if (branchRevisions.isEmpty()) {
            return null;
        }
        FileRevision firstOnBranch = (FileRevision)branchRevisions.get(0);
        return firstOnBranch.getChangeSetId();
    }

    private List getBranchRevisions(String branch) {
        ArrayList<FileRevision> branchRevisions = new ArrayList<FileRevision>();
        Iterator i2 = this.revisions.iterator();
        while (i2.hasNext()) {
            FileRevision fileRevision = (FileRevision)i2.next();
            if (!fileRevision.getBranch().equals(branch)) continue;
            branchRevisions.add(fileRevision);
        }
        return branchRevisions;
    }

    public SortedMultiMap getRevisionMap() {
        return this.revisions;
    }

    public static void addFileAncestry(RepositoryCache cache, MultiMap ancestry, RevInfoKey key, boolean includeDead, boolean physicalOnly) throws DbException {
        RevInfoKey firstRevKey;
        long rev = Long.parseLong(key.getRev());
        if (ancestry.containsKey(rev)) {
            return;
        }
        SortedMapFileHistory history = (SortedMapFileHistory)cache.getFileHistory(key.getPath(), physicalOnly);
        SortedMultiMap revisionMap = history.getRevisionMap().headMap(rev + 1L);
        if (revisionMap.size() == 0) {
            return;
        }
        List firstList = revisionMap.getList(revisionMap.firstKey());
        FileRevision firstRevision = (FileRevision)firstList.get(0);
        if (!firstRevision.isAdded() && !(firstRevKey = firstRevision.getRevInfoKey()).equals(key)) {
            SortedMapFileHistory.addFileAncestry(cache, ancestry, firstRevKey, false, physicalOnly);
        }
        for (Long csid : revisionMap.keySet()) {
            List csidRevisions = revisionMap.getList(csid);
            for (FileRevision fileRevision : csidRevisions) {
                RevInfoKey ancestorKey;
                AncestorLink ancestorLink;
                if (!fileRevision.isDead() || includeDead) {
                    if (ancestry.containsKey(csid)) {
                        if (!ancestry.getList(csid).contains(fileRevision)) {
                            ancestry.add(csid, fileRevision);
                        }
                    } else {
                        ancestry.add(csid, fileRevision);
                    }
                }
                if ((ancestorLink = fileRevision.getAncestorLink()) == null || ancestorLink.getType() == 0 || (ancestorKey = cache.getKey(ancestorLink.getRevid())) == null || ancestorKey.equals(key)) continue;
                FileRevision ancestor = cache.getFileRevision(ancestorKey);
                SortedMapFileHistory.addFileAncestry(cache, ancestry, ancestorKey, false, physicalOnly);
            }
        }
    }
}

