/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonFileRevision
extends FileRevision {
    private int revID;
    private AncestorLink ancestorLink;
    private Path path;
    private String revision;
    private String author;
    private String comment;
    private String branch;
    private boolean trunkLike;
    private long date;
    private long dateEnd;
    private boolean isBinary;
    private boolean isAdded;
    private boolean isDead;
    private boolean isCopy;
    private boolean isMove;
    private boolean isModify;
    private RevInfoKey copySource;
    private final List<RevInfoKey> copyDests = new LinkedList<RevInfoKey>();
    private RevInfoKey moveSource;
    private RevInfoKey moveDest;
    private int lineCount;
    private int linesAdded;
    private int linesRemoved;
    private int fileType = 1;
    private List<String> tags = Collections.emptyList();
    private List<String> branches = Collections.emptyList();
    private List<Integer> reviewIds = Collections.emptyList();
    private List<Hunk> hunks;
    private RevInfoKey predecessor;
    private RevInfoKey ancestor;

    @Override
    public String getAncestorRevision() {
        String revision = null;
        if (this.ancestor != null) {
            revision = this.ancestor.getRev();
        }
        return revision;
    }

    public void setAncestor(RevInfoKey ancestor) {
        this.ancestor = ancestor;
    }

    public RevInfoKey getAncestor() {
        return this.ancestor;
    }

    @Override
    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getPath(), this.getRevision());
    }

    @Override
    public int getRevID() {
        return this.revID;
    }

    public void setRevID(int revID) {
        this.revID = revID;
    }

    @Override
    public AncestorLink getAncestorLink() {
        return this.ancestorLink;
    }

    public void setAncestorLink(AncestorLink ancestorLink) {
        this.ancestorLink = ancestorLink;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public boolean isTrunkLike() {
        return this.trunkLike;
    }

    public void setTrunkLike(boolean trunkLike) {
        this.trunkLike = trunkLike;
    }

    @Override
    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    @Override
    public Date getDateValue() {
        return new Date(this.getDate());
    }

    @Override
    public long getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(long dateEnd) {
        this.dateEnd = dateEnd;
    }

    @Override
    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean binary) {
        this.isBinary = binary;
    }

    @Override
    public boolean isAdded() {
        return this.isAdded;
    }

    public void setAdded(boolean added) {
        this.isAdded = added;
    }

    @Override
    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean deleted) {
        this.isDead = deleted;
    }

    @Override
    public boolean isCopy() {
        return this.isCopy;
    }

    public void setCopy(boolean copy) {
        this.isCopy = copy;
    }

    @Override
    public boolean isMove() {
        return this.isMove;
    }

    public void setMove(boolean move) {
        this.isMove = move;
    }

    public void setModify(boolean modify) {
        this.isModify = modify;
    }

    @Override
    public boolean isModify() {
        return this.isModify;
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    @Override
    public int getLinesAdded() {
        return this.linesAdded;
    }

    public void setLinesAdded(int linesAdded) {
        this.linesAdded = linesAdded;
    }

    @Override
    public int getLinesRemoved() {
        return this.linesRemoved;
    }

    public void setLinesRemoved(int linesRemoved) {
        this.linesRemoved = linesRemoved;
    }

    @Override
    public List<String> getBranches() {
        return this.branches;
    }

    public void setBranches(List<String> branches) {
        this.branches = branches;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    @Override
    public RevInfoKey getCopySource() {
        return this.copySource;
    }

    public void setCopySource(RevInfoKey copySource) {
        this.copySource = copySource;
    }

    @Override
    public List<RevInfoKey> getCopyDestinations() throws DbException {
        return this.copyDests;
    }

    public void addCopyDestination(RevInfoKey key) {
        this.copyDests.add(key);
    }

    @Override
    public RevInfoKey getMoveSource() {
        return this.moveSource;
    }

    public void setMoveSource(RevInfoKey moveSource) {
        this.moveSource = moveSource;
    }

    @Override
    public RevInfoKey getMoveDestination() throws DbException {
        return this.moveDest;
    }

    public void setMoveDest(RevInfoKey moveDest) {
        this.moveDest = moveDest;
    }

    @Override
    public List<Integer> getReviewIds() {
        return this.reviewIds;
    }

    public void setReviewIds(List<Integer> reviewIds) {
        this.reviewIds = reviewIds;
    }

    @Override
    public List<Hunk> getHunks() {
        return this.hunks;
    }

    public void createDeletedHunk() {
        List<Hunk> deleteHunk = Collections.singletonList(Hunk.createDeleteHunk(1, 1, this.getLinesRemoved()));
        this.setHunks(deleteHunk);
    }

    public void createAdditionHunk() {
        if (!this.isBinary()) {
            List<Hunk> additionHunk = Collections.singletonList(Hunk.createAddHunk(1, 1, this.getLineCount()));
            this.setHunks(additionHunk);
        }
    }

    public void createReplaceHunk(int previousCount) {
        if (this.isBinary()) {
            List<Hunk> replaceHunk = Collections.singletonList(Hunk.createDeleteHunk(1, 1, this.getLinesRemoved()));
            this.setHunks(replaceHunk);
        } else {
            List<Hunk> replaceHunk = Collections.singletonList(new Hunk(0, 0, previousCount, this.getLineCount()));
            this.setHunks(replaceHunk);
        }
    }

    public void setHunks(List<Hunk> hunks) {
        this.hunks = hunks;
    }

    public void setPredecessor(RevInfoKey predecessor) {
        this.predecessor = predecessor;
    }

    public RevInfoKey getPredecessor() {
        return this.predecessor;
    }

    @Override
    public RevInfoKey getDiffRevision() {
        RevInfoKey key = this.getPredecessor();
        if (key == null) {
            key = this.getAncestor();
        }
        return key;
    }
}

