/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.fisheye.infinitydb.BitSetItemSpace;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.TagTreeVisitor;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;

public abstract class AbstractBeforeAfterQuery3
extends Query3 {
    protected final boolean inclusive;
    protected final boolean after;
    protected final boolean before;

    public AbstractBeforeAfterQuery3(boolean inclusive, boolean after, boolean before) {
        this.after = after;
        this.inclusive = inclusive;
        this.before = before;
    }

    protected void calculateRequiredReaders(TIntHashSet requiredReaders) {
    }

    protected _ItemSpace asItemSpace(_ItemSpace db, IndexReader[] readers) throws DbException {
        try {
            _ItemSpace revids = this.getInputRevids(db);
            if (this.inclusive && !this.after && !this.before) {
                return revids;
            }
            SortedIntSet bs = AbstractBeforeAfterQuery3.makeBitSet();
            TagTreeVisitor treeVisitor = new TagTreeVisitor(db);
            Collector collector = new Collector(bs);
            _Cu cu = _Cu.alloc();
            while (revids.next(cu)) {
                int revid = (int)cu.longAt(0);
                if (this.inclusive) {
                    bs.set(revid);
                }
                if (this.after) {
                    treeVisitor.visitDescendents(revid, collector);
                }
                if (!this.before) continue;
                treeVisitor.visitPredecessors(revid, collector);
            }
            return new BitSetItemSpace(bs);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean abstractEquals(AbstractBeforeAfterQuery3 that) {
        if (this == that) {
            return true;
        }
        if (this.after != that.after) {
            return false;
        }
        if (this.before != that.before) {
            return false;
        }
        return this.inclusive == that.inclusive;
    }

    protected abstract _ItemSpace getInputRevids(_ItemSpace var1) throws DbException;

    private static class Collector
    implements TagTreeVisitor.AncestorVisitor,
    TagTreeVisitor.DescendentVisitor {
        private final SortedIntSet bs;

        public Collector(SortedIntSet bs) {
            this.bs = bs;
        }

        public boolean visitAncestor(int revid, int predecessorid) throws DbException, IOException {
            this.bs.set(revid);
            return true;
        }

        public void visitDescendent(int revid) throws DbException, IOException {
            this.bs.set(revid);
        }
    }
}

