/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.Throttle;
import org.apache.commons.pool.PoolableObjectFactory;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnClientFactory
implements PoolableObjectFactory {
    private final SvnPasswordSupplier passwordSupplier;
    private final Throttle throttle;
    private final long timeout;
    private String repoDescriptor;

    public SvnClientFactory(String repoDescriptor, Throttle throttle, SvnPasswordSupplier passwordSupplier, long timeout) {
        this.repoDescriptor = repoDescriptor;
        this.throttle = throttle;
        this.passwordSupplier = passwordSupplier;
        this.timeout = timeout;
    }

    public Object makeObject() throws Exception {
        return this.createClient();
    }

    public SvnThrottledClient createClient() {
        if (this.throttle == null) {
            throw new IllegalStateException("SVN client factory throttle not set");
        }
        SVNClient client = new SVNClient();
        client.setPrompt((PromptUserPassword)this.passwordSupplier);
        return new SvnThrottledClient(this.repoDescriptor, this.throttle, (SVNClientInterface)client, this.timeout);
    }

    public void destroyObject(Object object) throws Exception {
    }

    public boolean validateObject(Object object) {
        return true;
    }

    public void activateObject(Object object) throws Exception {
    }

    public void passivateObject(Object object) throws Exception {
    }
}

