/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.svn.SvnPathRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnLogicalPathMatcher {
    public static final String TRUNK_ID = "trunk:";
    public static final String BRANCH_ID = "branch:";
    public static final String TAG_ID = "tag:";
    public static final String ROOT_ID = "root:";
    private List<SvnPathRule> trunkRules = new ArrayList<SvnPathRule>();
    private List<SvnPathRule> branchRules = new ArrayList<SvnPathRule>();
    private List<SvnPathRule> tagRules = new ArrayList<SvnPathRule>();
    private static final Map<Object, Object> extractionCache = new WeakHashMap<Object, Object>();

    public SvnLogicalPathMatcher() {
    }

    public boolean isEmpty() {
        return this.trunkRules.isEmpty() && this.branchRules.isEmpty() && this.tagRules.isEmpty();
    }

    public SvnLogicalPathMatcher(SvnSymbolicType symbolic) throws ConfigException {
        if (symbolic != null) {
            SvnSymbolicRuleType[] tagRules;
            SvnSymbolicRuleType[] branchRules;
            SvnSymbolicRuleType[] trunkRules;
            for (SvnSymbolicRuleType trunkRule : trunkRules = symbolic.getTrunkArray()) {
                this.addTrunkRule(this.parseSymbolRule(trunkRule));
            }
            for (SvnSymbolicRuleType branchRule : branchRules = symbolic.getBranchArray()) {
                this.addBranchRule(this.parseSymbolRule(branchRule));
            }
            for (SvnSymbolicRuleType tagRule : tagRules = symbolic.getTagArray()) {
                this.addTagRule(this.parseSymbolRule(tagRule));
            }
        }
    }

    private SvnPathRule parseSymbolRule(SvnSymbolicRuleType rule) throws ConfigException {
        Pattern p;
        try {
            p = Pattern.compile(rule.getRegex());
        }
        catch (PatternSyntaxException e2) {
            throw new ConfigException(e2);
        }
        return new SvnPathRule(p, rule.getName(), rule.getLogical());
    }

    public static void resetCache() {
        extractionCache.clear();
    }

    public void addTrunkRule(SvnPathRule rule) {
        this.trunkRules.add(rule);
    }

    public void addBranchRule(SvnPathRule rule) {
        this.branchRules.add(rule);
    }

    public void addTagRule(SvnPathRule rule) {
        this.tagRules.add(rule);
    }

    public String getTag(Path path) {
        String tagName = null;
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(TAG_ID)) {
            tagName = containerId.substring(containerId.indexOf(58) + 1);
            tagName = SvnLogicalPathMatcher.cacheName(tagName);
        }
        return tagName;
    }

    public Path getTagRoot(Path path) {
        SvnPathRule.Match match = this.findBestMatch(path);
        if (match == null || !match.getId().equals(TAG_ID)) {
            return null;
        }
        return match.getRoot();
    }

    public String getBranch(Path path) {
        String branchName = null;
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(BRANCH_ID)) {
            branchName = containerId.substring(containerId.indexOf(58) + 1);
            branchName = SvnLogicalPathMatcher.cacheName(branchName);
        }
        return branchName;
    }

    private boolean isTrunkName(String match) {
        for (SvnPathRule trunkRule : this.trunkRules) {
            if (!match.equals(trunkRule.getNamePattern())) continue;
            return true;
        }
        return false;
    }

    public String getTrunk(Path path) {
        String trunkName = null;
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(TRUNK_ID)) {
            trunkName = containerId.substring(containerId.indexOf(58) + 1);
            trunkName = SvnLogicalPathMatcher.cacheName(trunkName);
        }
        return trunkName;
    }

    private SvnPathRule.Match findBestMatch(Path p) {
        SvnPathRule.Match match = this.findBestMatch(this.branchRules, p, BRANCH_ID);
        if (match != null) {
            return match;
        }
        match = this.findBestMatch(this.tagRules, p, TAG_ID);
        if (match != null) {
            return match;
        }
        match = this.findBestMatch(this.trunkRules, p, TRUNK_ID);
        if (match != null) {
            return match;
        }
        return null;
    }

    private SvnPathRule.Match findBestMatch(List<SvnPathRule> rules, Path path, String id) {
        SvnPathRule.Match bestMatch = null;
        int bestTailLength = 0;
        for (SvnPathRule rule : rules) {
            SvnPathRule.Match match = rule.apply(path, id);
            if (match == null) continue;
            if (bestMatch == null) {
                bestMatch = match;
                bestTailLength = match.getLogicalTail().getPath().length();
                continue;
            }
            Path tail = match.getLogicalTail();
            int length = tail.getPath().length();
            if (length >= bestTailLength) continue;
            bestMatch = match;
            bestTailLength = length;
        }
        return bestMatch;
    }

    public Path getLogicalPath(Path physicalPath) {
        SvnPathRule.Match match = this.findBestMatch(physicalPath);
        if (match != null) {
            Path path = match.getLogicalPath();
            return SvnLogicalPathMatcher.cachePath(path);
        }
        return null;
    }

    public Path getLogicalTail(Path physicalPath) {
        SvnPathRule.Match match = this.findBestMatch(physicalPath);
        if (match != null) {
            Path path = match.getLogicalTail();
            return SvnLogicalPathMatcher.cachePath(path);
        }
        return null;
    }

    public String getContainerId(Path p) {
        SvnPathRule.Match match = this.findBestMatch(p);
        if (match != null) {
            String name = match.getName();
            if (!match.getId().equals(TRUNK_ID)) {
                while (this.isTrunkName(name)) {
                    name = ":" + name;
                }
                name = name.replace('/', '-');
            }
            return match.getId() + name;
        }
        return ROOT_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cacheName(String name) {
        Map<Object, Object> map = extractionCache;
        synchronized (map) {
            String canonical = (String)extractionCache.get(name);
            if (canonical == null) {
                extractionCache.put(new String(name), name);
                canonical = name;
            }
            return canonical;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path cachePath(Path path) {
        Map<Object, Object> map = extractionCache;
        synchronized (map) {
            Path canonical = (Path)extractionCache.get(path);
            if (canonical == null) {
                extractionCache.put(new Path(path), path);
                canonical = path;
            }
            return canonical;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnLogicalPathMatcher that = (SvnLogicalPathMatcher)o;
        if (this.branchRules != null ? !((Object)this.branchRules).equals(that.branchRules) : that.branchRules != null) {
            return false;
        }
        if (this.tagRules != null ? !((Object)this.tagRules).equals(that.tagRules) : that.tagRules != null) {
            return false;
        }
        return !(this.trunkRules != null ? !((Object)this.trunkRules).equals(that.trunkRules) : that.trunkRules != null);
    }

    public int hashCode() {
        int result = this.trunkRules != null ? ((Object)this.trunkRules).hashCode() : 0;
        result = 31 * result + (this.branchRules != null ? ((Object)this.branchRules).hashCode() : 0);
        result = 31 * result + (this.tagRules != null ? ((Object)this.tagRules).hashCode() : 0);
        return result;
    }
}

