/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryScanner;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.RevListCache;
import com.cenqua.fisheye.svn.DiffChangeSetProcessor;
import com.cenqua.fisheye.svn.SvnCache;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnContentProvider;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnRepositoryTester;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.diff.DiffFetcher;
import com.cenqua.fisheye.svn.diff.DiffProcessor;
import com.cenqua.fisheye.svn.diff.MessageInfo;
import com.cenqua.fisheye.svn.diff.SvnDiffException;
import com.cenqua.fisheye.svn.dump.DumpReader;
import com.cenqua.fisheye.svn.search.SVNQueryEvaluator;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.util.Throttle;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import gnu.trove.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRepositoryScanner
extends RepositoryScanner {
    private SvnThrottledClient svnClient;
    private DiffProcessor diffProcessor;
    private DiffChangeSetProcessor creationProcessor;
    private String accessKey;
    private static final int BATCH_SIZE = 200;
    public static final String MD5_SPECIFIER = "md5:";
    private long lastBlockEnd = -1L;
    private SvnRevInfoDAO dao;
    private SvnContentProvider contentProvider;

    public SvnRepositoryScanner(String name, SvnRepositoryInfo repInfo, SvnPasswordSupplier passwordSupplier, Throttle throttle, RepositoryStatus status) {
        super(name, repInfo, status, repInfo.isCaseSensitive());
        SvnClientFactory clientFactory = new SvnClientFactory(name, throttle, passwordSupplier, repInfo.getCommandTimeout());
        this.svnClient = clientFactory.createClient();
        repInfo.fillInRepositoryBasePathHistory(this.svnClient);
        SvnCache cache = new SvnCache(repInfo);
        this.setCache(cache);
        this.setSearchManager(new SearchManager(new SVNQueryEvaluator(this.getSvnCache())));
        cache.setClientFactory(clientFactory);
        this.setCommitBlockSize(400L);
        this.diffProcessor = new DiffProcessor(repInfo, clientFactory.createClient(), status);
        this.creationProcessor = new DiffChangeSetProcessor(repInfo, this.getSvnCache(), status);
    }

    @Override
    protected String getCacheVersion() {
        return "23";
    }

    public SvnCache getSvnCache() {
        return (SvnCache)this.getCache();
    }

    private SvnRepositoryInfo getSvnRepositoryInfo() {
        return (SvnRepositoryInfo)this.getRepositoryInfo();
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDump(File dumpFile) throws IOException, RepositoryClientException, DbException {
        long waitTime = 100L;
        if (!this.accessRepository(waitTime * 1000L)) {
            throw new DbException("Unable to access repository to perform load after " + waitTime + " seconds");
        }
        try {
            DumpReader reader = new DumpReader(this);
            reader.readDump(dumpFile);
            if (!this.getStatus().isDoneFullSlurp()) {
                this.getStatus().setDoneFullSlurp(true);
            }
        }
        finally {
            this.releaseRepository();
        }
    }

    @Override
    public void start() throws IOException, DbException {
        super.start();
        this.dao = this.getSvnCache().createDAO();
        this.creationProcessor.setDAO(this.getSvnCache().createDAO());
    }

    @Override
    protected SortedIntSet getPathRevids(SortedIntSet physicalPaths) throws DbException {
        SegmentedIntSet outdatedRevids = new SegmentedIntSet();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0) {
            this.dao.addPathRevIds(outdatedRevids, physicalPathId);
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        return outdatedRevids;
    }

    @Override
    protected Map<Long, LogMessage> getRevList(long startRevision, long endRevision) throws RepositoryClientException {
        HashMap<Long, LogMessage> result = null;
        if (endRevision > this.lastBlockEnd && endRevision >= startRevision) {
            long blockEnd;
            result = new HashMap<Long, LogMessage>();
            long blockStart = startRevision;
            do {
                LogMessage[] messages;
                blockEnd = endRevision > blockStart + 1024L ? blockStart + 1024L : endRevision;
                Revision.Number startRev = new Revision.Number(blockStart);
                Revision.Number endRev = new Revision.Number(blockEnd);
                SvnRepositoryInfo repositoryInfo = this.getSvnRepositoryInfo();
                for (LogMessage message : messages = this.svnClient.logMessages(repositoryInfo.getRepositoryRoot(blockEnd), (Revision)startRev, (Revision)endRev, !repositoryInfo.isFollowBaseHistory(), false)) {
                    result.put(message.getRevisionNumber(), message);
                }
                blockStart = blockEnd + 1L;
            } while ((long)result.size() < this.getCommitBlockSize() && blockEnd < endRevision);
            this.lastBlockEnd = blockEnd;
        }
        return result;
    }

    @Override
    protected SortedIntSet getRevidsInChangeSetRange(long startRevision, long endRevision) throws DbException {
        return this.dao.getRevidsInChangeSetRange(startRevision, endRevision);
    }

    @Override
    protected SortedIntSet getPhysicalPaths(long startRevision, long endRevision) throws DbException {
        SortedIntSet revids = this.dao.getRevidsInChangeSetRange(startRevision, endRevision);
        return this.dao.getPhysicalPaths(revids);
    }

    @Override
    protected void indexRevisions(SortedIntSet revids) throws DbException {
        SvnCache cache = this.getSvnCache();
        ArrayList<SvnRevInfo> revisions = new ArrayList<SvnRevInfo>();
        int count = 0;
        int total = revids.cardinality();
        int revid = revids.nextSetBit(0);
        while (revid >= 0 && !this.getStatus().isStopRequested()) {
            revisions.add(this.dao.loadRevision(revid));
            ++count;
            if (revisions.size() >= 200) {
                this.getStatus().setMessage("Indexing revision metadata item " + count + " of " + total);
                this.getIndexer().indexBatch(revisions);
                revisions.clear();
                cache.setScanProperty("LastMetadataRevid", revid);
                cache.commit();
                this.clearSetUpto(revids, revid);
            }
            revid = revids.nextSetBit(revid + 1);
        }
        this.getIndexer().indexBatch(revisions);
        cache.setScanProperty("LastMetadataRevid", -1L);
        cache.commit();
        this.clearSetUpto(revids, revids.length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indexUpdatedContent(SortedIntSet physicalPaths) throws DbException, IOException {
        SvnCache cache = this.getSvnCache();
        File contentFile = File.createTempFile("content", null, this.getRepositoryInfo().getRepoTempDir());
        SvnLogicalPathMatcher pathMatcher = this.getSvnRepositoryInfo().getPathMatcher();
        try {
            int pathIndex = 0;
            int count = physicalPaths.cardinality();
            int physicalPathId = physicalPaths.nextSetBit(0);
            while (physicalPathId >= 0 && !this.getStatus().isStopRequested()) {
                String containerId;
                ++pathIndex;
                Path physicalPath = this.dao.getPhysicalPath(physicalPathId);
                if (this.getRepositoryInfo().isPathInRepo(physicalPath) && ((containerId = pathMatcher.getContainerId(physicalPath)).startsWith("root:") || containerId.startsWith("trunk:"))) {
                    long csid = this.dao.getLatestPathChange(physicalPath);
                    int revid = this.dao.getRevId(physicalPath, csid);
                    SvnRevInfo revision = this.dao.loadRevision(revid);
                    boolean doExport = true;
                    if (revision == null || revision.isBinary() || revision.isDead()) {
                        doExport = false;
                    }
                    if (revision.getFileType() != 1) {
                        doExport = false;
                    }
                    if (revision.getProperties().containsKey("svn:special")) {
                        doExport = false;
                    }
                    if (doExport) {
                        this.getStatus().setMessage("Indexing content: " + physicalPath + " (" + pathIndex + " of " + count + ")");
                        this.exportContent(this.getContentProvider(), contentFile, physicalPath, revision);
                    }
                }
                if (pathIndex % 200 == 0) {
                    cache.setScanProperty("LastContentRevid", physicalPathId);
                    cache.commit();
                    this.clearSetUpto(physicalPaths, physicalPathId);
                }
                physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
            }
        }
        finally {
            contentFile.delete();
        }
        cache.setScanProperty("LastContentRevid", -1L);
        cache.commit();
        this.clearSetUpto(physicalPaths, physicalPaths.length() + 1);
    }

    private void exportContent(SvnContentProvider contentProvider, File contentFile, Path physicalPath, SvnRevInfo revision) throws IOException, DbException {
        contentFile.delete();
        boolean exported = false;
        try {
            exported = contentProvider.exportContent(physicalPath, contentFile, revision.getSvnRevision());
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.warn((Object)"Error exporting content for indexing", (Throwable)e2);
        }
        if (!exported) {
            Logs.APP_LOG.warn((Object)("Skipping " + physicalPath + " as content is not available"));
        } else if (contentFile.length() >= 0x500000L) {
            Logs.APP_LOG.warn((Object)("Not indexing contents of HEAD of " + physicalPath + " because its size (" + contentFile.length() + "B) is too large (limit is 5MB)"));
        } else if (!contentFile.exists()) {
            Logs.APP_LOG.error((Object)("Not indexing contents of HEAD of " + physicalPath + " because content was not exported"));
        } else {
            Charset encoding = contentProvider.getTextEncoding(revision.getRevInfoKey());
            this.getIndexer().indexContent((FileRevision)revision, contentFile, encoding);
        }
    }

    @Override
    protected void validateRepo() throws ConfigException {
        this.checkRepoSettings();
        this.validateAccess();
    }

    private DiffFetcher createDiffFetcherThread() {
        DiffFetcher diffFetcher = new DiffFetcher();
        diffFetcher.setProcessor(this.diffProcessor);
        Thread fetcherThread = new Thread((Runnable)diffFetcher, "FishEye SVN Diff Fetcher");
        fetcherThread.setDaemon(true);
        fetcherThread.start();
        return diffFetcher;
    }

    @Override
    protected long getLatestRevision() throws RepositoryClientException, ConfigException {
        SvnRepositoryInfo repInfo = this.getSvnRepositoryInfo();
        long latestRevision = -1L;
        Info2[] info = this.svnClient.info2(repInfo.getRepositoryRoot(-1L), Revision.HEAD, Revision.HEAD, false);
        if (info.length != 0) {
            latestRevision = info[0].getLastChangedRev();
            if (latestRevision <= 0L) {
                latestRevision = info[0].getRev();
            }
        } else {
            DirEntry[] dirEntries = this.svnClient.list(repInfo.getRepositoryRoot(-1L), Revision.HEAD, Revision.HEAD, false);
            if (dirEntries.length != 0) {
                for (DirEntry entry : dirEntries) {
                    if (entry.getLastChangedRevisionNumber() <= latestRevision) continue;
                    latestRevision = entry.getLastChangedRevisionNumber();
                }
            }
        }
        if (latestRevision < 0L) {
            throw new ConfigException("Unable to determine latest revision of the Subversion repository: " + repInfo.getRepositoryDescriptor());
        }
        return latestRevision;
    }

    @Override
    protected boolean processTags() throws RepositoryClientException, DbException {
        return false;
    }

    @Override
    protected void setCreateOnDemand(boolean createOnDemand) {
        this.creationProcessor.setCreateAsRequired(createOnDemand);
    }

    @Override
    protected void createInitialImport(RevListCache revListCache, long startRevision) throws DbException {
        this.creationProcessor.createInitialImport(revListCache.getRevisions(), startRevision);
    }

    @Override
    protected long getFirstRevision() throws RepositoryClientException {
        long firstRev = -1L;
        SvnRepositoryInfo repositoryInfo = this.getSvnRepositoryInfo();
        LogMessage[] messages = this.svnClient.logMessages(repositoryInfo.getRepositoryRoot(-1L), (Revision)new Revision.Number(0L), Revision.HEAD, !repositoryInfo.isFollowBaseHistory(), false, 1L);
        if (messages.length >= 1 && (firstRev = messages[0].getRevisionNumber()) == 0L) {
            firstRev = 1L;
        }
        if (firstRev < 0L) {
            Logs.APP_LOG.warn((Object)"Unable to determine initial revision in repository");
            firstRev = 1L;
        }
        return firstRev;
    }

    private void checkRepoSettings() throws ConfigException {
        SvnRepositoryTester tester = new SvnRepositoryTester(this.svnClient, this.getSvnRepositoryInfo(), this.accessKey);
        tester.checkRepoSettings();
    }

    @Override
    protected void validateAccess() throws ConfigException {
        SvnRepositoryInfo repoInfo = this.getSvnRepositoryInfo();
        SvnRepositoryTester tester = new SvnRepositoryTester(this.svnClient, repoInfo, this.accessKey);
        tester.pingAndValidateAccess(this.getSvnRepositoryInfo().getRepositoryRoot(-1L), this.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long slurpRevisionBlock(long startRevision, long endRevision) throws DbException, RepositoryClientException {
        Logs.APP_LOG.info((Object)("Slurping from " + startRevision + " to " + endRevision));
        Revision.Number startRev = new Revision.Number(startRevision);
        Revision.Number endRev = new Revision.Number(endRevision);
        Timer timer = new Timer("SVN Slurp on " + this.getRepositoryInfo().getRepositoryDescriptor());
        this.getStatus().setMessage("Reading revisions " + startRevision + " to " + endRevision + ".");
        SvnRepositoryInfo repositoryInfo = this.getSvnRepositoryInfo();
        LogMessage[] messages = this.svnClient.logMessages(repositoryInfo.getRepositoryRoot(endRevision), (Revision)startRev, (Revision)endRev, !repositoryInfo.isFollowBaseHistory(), true);
        if (messages != null) {
            this.getStatus().setMessage("Fetching diffs.");
            DiffFetcher diffFetcher = null;
            try {
                long numRevs = endRevision - startRevision;
                if (numRevs > 1L) {
                    diffFetcher = this.createDiffFetcherThread();
                    diffFetcher.processMessages(messages);
                }
                for (int index = 0; index < messages.length && !this.getStatus().isStopRequested(); ++index) {
                    MessageInfo messageInfo;
                    LogMessage message = messages[index];
                    Logs.APP_LOG.debug((Object)("Processing revision " + message.getRevisionNumber() + " in " + this.getRepositoryInfo().getRepositoryDescriptor()));
                    try {
                        messageInfo = diffFetcher == null ? this.diffProcessor.processMessage(message) : diffFetcher.getMessageInfo(message);
                    }
                    catch (SvnDiffException e2) {
                        throw new DbException("Problem getting diff information for rev" + message.getRevisionNumber(), e2);
                    }
                    if (messageInfo == null) {
                        throw new DbException("Problem getting diff information for rev" + message.getRevisionNumber());
                    }
                    messageInfo.setRevProps(this.svnClient.revProperties(this.getSvnRepositoryInfo().getRepositoryRoot(message.getRevisionNumber()), (Revision)message.getRevision()));
                    this.getStatus().setMessage("Processing revision " + message.getRevisionNumber());
                    this.creationProcessor.createChangeSet(message, messageInfo);
                }
            }
            finally {
                if (diffFetcher != null) {
                    Logs.APP_LOG.debug((Object)"Stopping diff fetcher");
                    diffFetcher.stopProcessing();
                }
            }
        }
        timer.end();
        return endRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateRevisions(long start, long end) throws DbException, RepositoryClientException {
        String resultMessage = null;
        if (!this.accessRepository(10000L)) {
            resultMessage = "Unable to update revisions as repository is busy with another operation";
        } else {
            boolean rollbackRequired = false;
            SvnCache cache = this.getSvnCache();
            try {
                TLongHashSet changesets = cache.getChangesets(start, end);
                long first = -1L;
                long last = -1L;
                for (long csid : changesets) {
                    if (first == -1L || first > csid) {
                        first = csid;
                    }
                    if (last == -1L || last < csid) {
                        last = csid;
                    }
                    Logs.APP_LOG.debug((Object)("Updating revision:" + csid));
                    SvnChangeSet changeSet = (SvnChangeSet)cache.getChangeSet(Long.toString(csid));
                    PropertyData[] revProps = this.svnClient.revProperties(this.getSvnRepositoryInfo().getRepositoryRoot(csid), (Revision)new Revision.Number(csid));
                    rollbackRequired = true;
                    this.updateChangeSet(cache, changeSet, revProps);
                    cache.commit();
                    rollbackRequired = false;
                }
                if (first != -1L && last != -1L) {
                    this.indexMetadata(first, last);
                }
            }
            finally {
                if (rollbackRequired) {
                    resultMessage = "Some updates were rolledback due to error";
                    cache.rollback();
                }
                this.releaseRepository();
            }
        }
        return resultMessage;
    }

    private void updateChangeSet(SvnCache cache, SvnChangeSet changeSet, PropertyData[] revProps) throws DbException {
        HashSet<String> revPropSet = new HashSet<String>();
        for (PropertyData revProp : revProps) {
            String name = revProp.getName();
            String value = revProp.getValue();
            if (value == null) continue;
            if (name.equals("svn:log")) {
                if (value.equals(changeSet.getComment())) continue;
                Logs.APP_LOG.debug((Object)("Updating svn:log for " + changeSet.getId()));
                this.updateRevisionComment(cache, changeSet, value);
                continue;
            }
            if (name.equals("svn:author")) {
                if (value.equals(changeSet.getAuthor())) continue;
                Logs.APP_LOG.debug((Object)("Updating svn:author for " + changeSet.getId()));
                this.updateRevisionAuthor(cache, changeSet, value);
                continue;
            }
            if (name.equals("svn:date")) {
                try {
                    long newDate = ISO8601DateHelper.parse(value).getTime();
                    if (newDate == changeSet.getDate()) continue;
                    Logs.APP_LOG.debug((Object)("Updating svn:date for " + changeSet.getId()));
                    this.updateRevisionDate(cache, changeSet, newDate);
                }
                catch (ISO8601DateHelper.InvalidDateException e2) {
                    Logs.APP_LOG.error((Object)("Unable to update date value: " + value), (Throwable)e2);
                }
                continue;
            }
            Logs.APP_LOG.debug((Object)("Updating " + name + " revprop for " + changeSet.getId()));
            this.updateRevisionProperty(cache, changeSet, name, value);
            revPropSet.add(name);
        }
        this.removePurgedRevProps(cache, Long.parseLong(changeSet.getId()), revPropSet);
    }

    private void removePurgedRevProps(SvnCache cache, long csid, Set retainSet) throws DbException {
        cache.removePurgedRevProps(csid, retainSet);
    }

    private void updateRevisionProperty(SvnCache cache, SvnChangeSet changeSet, String name, String value) throws DbException {
        long csid = Long.parseLong(changeSet.getId());
        cache.updateRevisionProperty(csid, name, value);
    }

    private void updateRevisionComment(SvnCache cache, SvnChangeSet changeSet, String value) throws DbException {
        Iterator<RevInfoKey> i2 = changeSet.getRevisionInfoKeys();
        while (i2.hasNext()) {
            RevInfoKey key = i2.next();
            cache.updateRevisionComment(key, value);
        }
    }

    private void updateRevisionAuthor(SvnCache cache, SvnChangeSet changeSet, String value) throws DbException {
        Iterator<RevInfoKey> i2 = changeSet.getRevisionInfoKeys();
        while (i2.hasNext()) {
            RevInfoKey key = i2.next();
            cache.updateRevisionAuthor(key, value);
        }
    }

    private void updateRevisionDate(SvnCache cache, SvnChangeSet changeSet, long date) throws DbException {
        Iterator<RevInfoKey> i2 = changeSet.getRevisionInfoKeys();
        while (i2.hasNext()) {
            RevInfoKey key = i2.next();
            cache.updateRevisionDate(key, date);
        }
    }

    public void requestStop() {
        this.diffProcessor.requestStop();
        this.creationProcessor.requestStop();
    }

    public void createChangeSet(LogMessage logMessage, MessageInfo messageInfo) throws DbException {
        this.creationProcessor.createChangeSet(logMessage, messageInfo);
    }

    public void setContentProvider(SvnContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public SvnContentProvider getContentProvider() {
        SvnContentProvider provider = this.contentProvider;
        if (provider == null) {
            provider = this.getSvnCache();
        }
        return provider;
    }
}

