/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.UserLogin;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AJPAuth
extends BaseAuth {
    private final boolean isAutoAdd;

    public AJPAuth(AjpAuthConfigType cfg) {
        this(cfg, Logs.APP_LOG, Logs.PERF_LOG);
    }

    public AJPAuth(AjpAuthConfigType cfg, Logger appLog, Logger perfLog) {
        super(appLog, perfLog);
        this.isAutoAdd = cfg.getAutoAdd();
    }

    public void close() {
    }

    public boolean getAutoAdd() {
        return this.isAutoAdd;
    }

    public BaseAuth.AuthTok checkPassword(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        return this.checkUsername(username);
    }

    public boolean hasPermissionToAccess(BaseAuth.AuthTok atok, boolean defaultResult, RepositoryHandle cfg) {
        return defaultResult;
    }

    public int getAuthType() {
        return 5;
    }

    public BaseAuth.AuthTok recreateAuth(String username) {
        return this.checkUsername(username);
    }

    public BaseAuth.AuthTok checkRequest(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getRemoteUser();
        return this.checkUsername(username);
    }

    public boolean isRequestUserStillValid(UserLogin user, BaseAuth.AuthTok authTok, HttpServletRequest req, HttpServletResponse response) {
        String username = user.getUsername();
        if (!username.equals(req.getRemoteUser())) {
            Logs.APP_LOG.info((Object)("User: '" + username + "' does not match request delegated user: '" + req.getRemoteUser() + "'"));
            return false;
        }
        return true;
    }

    private BaseAuth.AuthTok checkUsername(String username) {
        return username != null ? new AjpAuthTok(username) : null;
    }

    public static class AjpAuthTok
    extends BaseAuth.AuthTok {
        private final String username;

        AjpAuthTok(String username) {
            this.username = username;
        }

        public String getEmail() {
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayName() {
            return null;
        }

        public int getAuthType() {
            return 5;
        }
    }
}

