/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.Interval;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAuth {
    protected final Logger appLog;
    protected final Logger perfLog;
    private long ttl = 0L;

    protected BaseAuth(Logger appLog, Logger perfLog) {
        this.appLog = appLog;
        this.perfLog = perfLog;
    }

    public abstract void close();

    public abstract boolean getAutoAdd();

    public abstract AuthTok checkPassword(String var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    public abstract boolean hasPermissionToAccess(AuthTok var1, boolean var2, RepositoryHandle var3);

    public abstract int getAuthType();

    protected void setPermCacheTTL(String s) {
        try {
            Interval ttlInterval = new Interval(s);
            this.ttl = ttlInterval.getValueInMillis();
        }
        catch (NumberFormatException e2) {
            this.appLog.warn((Object)("badly formatted interval " + e2.getMessage()));
        }
    }

    protected void setCache(AuthTok tok, String repname, boolean result) {
        if (this.ttl == 0L) {
            return;
        }
        if (!result) {
            if (tok.permCache != null) {
                tok.permCache.remove(repname);
            }
            return;
        }
        if (tok.permCache == null) {
            tok.permCache = new HashMap();
        }
        Long timestamp = System.currentTimeMillis();
        tok.permCache.put(repname, timestamp);
    }

    protected Boolean checkCache(AuthTok tok, String repname) {
        boolean expired;
        if (tok.permCache == null) {
            return null;
        }
        Long timestamp = (Long)tok.permCache.get(repname);
        if (timestamp == null) {
            return null;
        }
        long expires = timestamp + this.ttl;
        boolean bl = expired = expires < System.currentTimeMillis();
        if (expired) {
            tok.permCache.remove(repname);
            return null;
        }
        return Boolean.TRUE;
    }

    protected boolean isRequestUserStillValid(UserLogin user, AuthTok authTok, HttpServletRequest req, HttpServletResponse response) {
        return true;
    }

    public abstract AuthTok recreateAuth(String var1);

    public abstract AuthTok checkRequest(HttpServletRequest var1, HttpServletResponse var2);

    public void logout(UserLogin login, HttpServletRequest request, HttpServletResponse response) {
    }

    public boolean supportsGroups() {
        return false;
    }

    public List<String> listGroups() {
        return null;
    }

    public List<String> getUsersInGroup(String group) {
        return null;
    }

    public boolean isUserInGroup(String group, String username) {
        return false;
    }

    public List<String> getGroupsForUser(String username) {
        return null;
    }

    public static class BuiltInAuthTok
    extends AuthTok {
        private final FEUser user;

        public BuiltInAuthTok(FEUser user) {
            this.user = user;
        }

        public String getEmail() {
            return this.user.getEmail();
        }

        public String getUsername() {
            return this.user.getUsername();
        }

        public String getDisplayName() {
            return this.user.getDisplayName();
        }

        public int getAuthType() {
            return 1;
        }
    }

    public static abstract class AuthTok {
        Map permCache;

        public abstract String getEmail();

        public abstract String getUsername();

        public abstract String getDisplayName();

        public abstract int getAuthType();
    }
}

