/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.os;

import antlr.ANTLRException;
import com.cenqua.fisheye.config1.HostAuthRepositoryConfigType;
import com.cenqua.fisheye.config1.HostauthConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.util.VariableSubstituter;
import com.cenqua.fisheye.util.cond.AtomEvaluator;
import com.cenqua.fisheye.util.cond.AtomExpr;
import com.cenqua.fisheye.util.cond.BoolExpr;
import com.cenqua.shaj.Authenticator;
import com.cenqua.shaj.PAMAuthenticator;
import com.cenqua.shaj.log.Log;
import com.cenqua.shaj.log.Log4Log;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class HostAuth
extends BaseAuth {
    private static final String DEFAULT_PAM_SERVICE = "fisheye";
    private final boolean autoAdd;
    private String domain;
    private final BoolExpr requiredGroup;

    public HostAuth(HostauthConfigType cfg) {
        this(cfg, Logs.APP_LOG, Logs.PERF_LOG);
    }

    public HostAuth(HostauthConfigType cfg, Logger appLog, Logger perfLog) {
        super(appLog, perfLog);
        this.autoAdd = cfg.getAutoAdd();
        this.requiredGroup = cfg.isSetRequiredGroup() ? this.parseGroupExpression(cfg.getRequiredGroup()) : null;
        this.domain = cfg.isSetDomain() ? cfg.getDomain() : null;
        this.setPermCacheTTL(cfg.getPositiveCacheTtl());
        if (PAMAuthenticator.isSupported() && this.domain == null) {
            this.domain = DEFAULT_PAM_SERVICE;
        }
    }

    public void close() {
    }

    public boolean getAutoAdd() {
        return this.autoAdd;
    }

    public int getAuthType() {
        return 3;
    }

    public BaseAuth.AuthTok checkPassword(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        if (username == null || "".equals(username)) {
            this.appLog.debug((Object)"host-auth: can't check an empty username");
            return null;
        }
        if (password == null) {
            this.appLog.debug((Object)"host-auth: can't check a null password");
            return null;
        }
        long t0 = System.currentTimeMillis();
        boolean success = Authenticator.getDefault().checkPassword(this.domain, username, password, (Log)new Log4Log(this.appLog));
        long t1 = System.currentTimeMillis();
        if (this.perfLog.isInfoEnabled()) {
            this.perfLog.info((Object)("host-auth password check for " + username + " in " + (t1 - t0) + "ms"));
        }
        if (!success) {
            return null;
        }
        if (!this.hasGlobalPerm(username)) {
            return null;
        }
        HostAuthTok tok = new HostAuthTok(username);
        return tok;
    }

    private boolean hasGlobalPerm(String username) {
        if (this.requiredGroup != null && !this.checkGroupMembership(username, this.requiredGroup, null)) {
            this.appLog.info((Object)("user " + username + " had correct password but was not in required group"));
            return false;
        }
        return true;
    }

    public BaseAuth.AuthTok recreateAuth(String username) {
        if (!this.hasGlobalPerm(username)) {
            return null;
        }
        HostAuthTok tok = new HostAuthTok(username);
        return tok;
    }

    public boolean hasPermissionToAccess(BaseAuth.AuthTok atok, boolean defaultResult, RepositoryHandle rcfg) {
        HostAuthRepositoryConfigType constraint = rcfg.getCfg().getHostAuthConstraint();
        if (constraint == null) {
            return defaultResult;
        }
        if (!(atok instanceof HostAuthTok)) {
            return false;
        }
        HostAuthTok tok = (HostAuthTok)atok;
        String repname = rcfg.getName();
        Boolean cacheResult = this.checkCache(tok, repname);
        if (cacheResult != null) {
            if (this.appLog.isDebugEnabled()) {
                this.appLog.debug((Object)("HOSTAUTH: got perm check from the cache, " + tok.username + " against rep " + repname));
            }
            return cacheResult;
        }
        String group = constraint.getRequiredGroup();
        boolean result = this.checkGroupMembership(tok.username, this.parseGroupExpression(group), rcfg.getName());
        this.setCache(tok, repname, result);
        return result;
    }

    private BoolExpr parseGroupExpression(String group) {
        try {
            return BoolExpr.parse(group);
        }
        catch (ANTLRException e2) {
            Logs.APP_LOG.error((Object)("could not parse group expression: " + group), (Throwable)e2);
            return new AtomExpr(group);
        }
    }

    private boolean checkGroupMembership(final String username, BoolExpr groupexpr, String repname) {
        final Log4Log log = new Log4Log(this.appLog);
        final HashMap<String, String> filterVars = new HashMap<String, String>();
        filterVars.put("USERNAME", username);
        if (repname != null) {
            filterVars.put("REP", repname);
        }
        AtomEvaluator eval = new AtomEvaluator(){

            public boolean eval(String ident) {
                String group = VariableSubstituter.substituteRefs((CharSequence)ident, filterVars);
                return Authenticator.getDefault().checkGroupMembership(HostAuth.this.domain, username, group, (Log)log);
            }
        };
        return groupexpr.evaluate(eval);
    }

    public BaseAuth.AuthTok checkRequest(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public static class HostAuthTok
    extends BaseAuth.AuthTok {
        private final String username;

        HostAuthTok(String username) {
            this.username = username;
        }

        public String getEmail() {
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayName() {
            return null;
        }

        public int getAuthType() {
            return 3;
        }
    }
}

