/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache {
    private final LRUMap mMap;
    private final boolean mWeak;

    public LRUCache(int maxEntries, boolean weak, CacheListener listener) {
        this.mMap = new LRUMap(maxEntries, listener);
        this.mWeak = weak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, ValueFactory factory) throws ValueFactoryException {
        Node node;
        Object object = this.mMap;
        synchronized (object) {
            node = (Node)this.mMap.get(key);
            if (node == null) {
                node = new Node();
                this.mMap.put(key, node);
            }
        }
        object = node;
        synchronized (object) {
            Reference ref;
            if (node.value == null) {
                return this.createValueForNode(key, node, factory);
            }
            Object currentVal = node.value;
            if (this.mWeak && (currentVal = (ref = (Reference)currentVal).get()) == null) {
                return this.createValueForNode(key, node, factory);
            }
            this.updateValueForNode(key, currentVal, factory);
            return currentVal;
        }
    }

    private void updateValueForNode(Object key, Object currentVal, ValueFactory factory) throws ValueFactoryException {
        try {
            factory.updateValue(key, currentVal);
        }
        catch (Exception e2) {
            throw new ValueFactoryException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(Object key) {
        LRUMap lRUMap = this.mMap;
        synchronized (lRUMap) {
            this.mMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAll() {
        LRUMap lRUMap = this.mMap;
        synchronized (lRUMap) {
            this.mMap.clear();
        }
    }

    private Object createValueForNode(Object key, Node node, ValueFactory factory) throws ValueFactoryException {
        try {
            Object val = factory.createValue();
            node.value = this.mWeak ? new SoftReference<Object>(val) : val;
            this.fireAddedValue(val, key);
            return val;
        }
        catch (Exception e2) {
            throw new ValueFactoryException(e2);
        }
    }

    private void fireAddedValue(Object val, Object key) {
        if (this.mMap.mListener != null && val != null) {
            this.mMap.mListener.addedValue(key, val);
        }
    }

    private static class Node {
        public Object value;

        private Node() {
        }
    }

    private class LRUMap
    extends LinkedHashMap {
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final int mMaxEntries;
        private final CacheListener mListener;

        public LRUMap(int maxEntries, CacheListener listener) {
            super(maxEntries, 0.75f, true);
            this.mMaxEntries = maxEntries;
            this.mListener = listener;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean overflow;
            boolean bl = overflow = this.size() > this.mMaxEntries;
            if (this.mListener != null && overflow) {
                this.fireRemovedValue(eldest.getKey(), eldest.getValue());
            }
            return overflow;
        }

        public Object remove(Object key) {
            Object value = super.remove(key);
            if (this.mListener != null && value != null) {
                this.fireRemovedValue(key, value);
            }
            return value;
        }

        public Object put(Object key, Object value) {
            Object previousValue = super.put(key, value);
            if (this.mListener != null && previousValue != null) {
                this.fireRemovedValue(key, value);
            }
            return previousValue;
        }

        public void clear() {
            super.clear();
            if (this.mListener != null) {
                this.mListener.removedAll();
            }
        }

        private void fireRemovedValue(Object key, Object value) {
            if (LRUCache.this.mWeak) {
                Reference ref = (Reference)value;
                Object refValue = ref.get();
                if (refValue == null) {
                    Logs.APP_LOG.warn((Object)("For key: " + key + ", weak ref. value is null. Not calling listener."));
                } else {
                    this.mListener.removedValue(key, refValue);
                }
            } else {
                this.mListener.removedValue(key, ((Node)value).value);
            }
        }
    }

    public static class ValueFactoryException
    extends Exception {
        private final Exception mE;

        public ValueFactoryException(Exception cause) {
            super(cause);
            this.mE = cause;
        }

        public Exception getException() {
            return this.mE;
        }
    }

    public static interface CacheListener {
        public void removedValue(Object var1, Object var2);

        public void addedValue(Object var1, Object var2);

        public void removedAll();
    }

    public static interface ValueFactory {
        public Object createValue() throws Exception;

        public void updateValue(Object var1, Object var2) throws Exception;
    }
}

