/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableSubstituter {
    private static final Pattern REPLACE_TOKEN = Pattern.compile("\\$\\{((\\w|\\d|[_.])+)\\}");

    public static String substituteRefs(CharSequence input, final Map map) {
        VariableMap vmap = new VariableMap(){

            public CharSequence map(String variable) {
                return (CharSequence)map.get(variable);
            }
        };
        return VariableSubstituter.substituteRefs(input, vmap);
    }

    public static String substituteRefs(CharSequence input, VariableMap map) {
        StringBuffer out = new StringBuffer(input.length());
        VariableSubstituter.substituteRefs(input, out, map);
        return out.toString();
    }

    public static void substituteRefs(CharSequence input, StringBuffer output, VariableMap map) {
        Matcher matcher = REPLACE_TOKEN.matcher(input);
        int start = 0;
        while (matcher.find()) {
            output.append(input.subSequence(start, matcher.start()));
            String token = matcher.group(1);
            CharSequence region = map.map(token);
            if (region != null) {
                output.append(region);
            } else {
                output.append(matcher.group());
            }
            start = matcher.end();
        }
        output.append(input.subSequence(start, input.length()));
    }

    public static interface VariableMap {
        public CharSequence map(String var1);
    }
}

