/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.vis.AgeColourer;
import com.cenqua.fisheye.vis.AnnotationColourer;
import com.cenqua.fisheye.vis.BlameColourer;
import gnu.trove.TLongObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.category.DefaultCategoryDataset;

public class AgeBlameColourer
extends AnnotationColourer {
    final DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    final BlameColourer blameColourer = new BlameColourer();
    final AgeColourer ageColourer = new AgeColourer();

    protected void processEmpty() {
        this.blameColourer.processEmpty();
    }

    protected void process() {
        this.blameColourer.mChunks = this.mChunks;
        this.ageColourer.mChunks = this.mChunks;
        this.blameColourer.process();
        this.ageColourer.process();
        TLongObjectHashMap chunkMap = this.ageColourer.getChunkMap();
        for (int i2 = 0; i2 < this.ageColourer.getLegendSize(); ++i2) {
            String period = this.ageColourer.getLegendName(i2);
            AnnotationColourer.ChunkGroup chunkGroup = (AnnotationColourer.ChunkGroup)chunkMap.get(this.ageColourer.getLegendKey(i2));
            HashMap<String, AnnotationColourer.ChunkGroup> authorMap = new HashMap<String, AnnotationColourer.ChunkGroup>();
            Blame.BlameChunk[] chunks = chunkGroup.toArray();
            for (int j = 0; j < chunks.length; ++j) {
                AgeBlameColourer.addToChunkGroupInMap(authorMap, chunks[j].getInfo().getAuthor(), chunks[j]);
            }
            for (Map.Entry entry : authorMap.entrySet()) {
                AnnotationColourer.ChunkGroup authChunks = (AnnotationColourer.ChunkGroup)entry.getValue();
                String author = (String)entry.getKey();
                author = author == null ? "no_author" : author;
                this.dataset.addValue((double)authChunks.getChunkTotal(), (Comparable)((Object)author), (Comparable)((Object)period));
            }
            if (this.dataset.getColumnIndex((Comparable)((Object)period)) >= 0) continue;
            this.dataset.addValue(0.0, (Comparable)((Object)""), (Comparable)((Object)period));
        }
    }

    public DefaultCategoryDataset getDataset() {
        return this.dataset;
    }

    public int authPosition(String author) {
        return this.blameColourer.authPosition(author);
    }

    public int getLegendSize() {
        return this.blameColourer.getLegendSize();
    }

    public String getLegendStyle(int i2) {
        return this.blameColourer.getLegendStyle(i2);
    }

    public String getLegendName(int i2) {
        return this.blameColourer.getLegendName(i2);
    }

    public long getLegendKey(int i2) {
        return this.blameColourer.getLegendKey(i2);
    }

    public int getLegendLOC(int i2) {
        return this.blameColourer.getLegendLOC(i2);
    }

    public int getLegendStyleKey(int i2) {
        return this.blameColourer.getLegendStyleKey(i2);
    }

    public String getLineStyle(int idx, Blame.BlameChunk chunk) {
        return this.blameColourer.getLineStyle(idx, chunk);
    }
}

