/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.vis.AnnotationColourer;
import gnu.trove.TLongObjectHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class AgeColourer
extends AnnotationColourer {
    private final long mNow = System.currentTimeMillis();
    private long mMinAge;
    private long mMaxAge;
    protected TLongObjectHashMap mChunkMap;
    private long[] mLegendNames;

    AgeColourer() {
    }

    protected void processEmpty() {
        this.mChunkMap = new TLongObjectHashMap();
        this.mLegendNames = new long[0];
    }

    protected void process() {
        long date;
        Blame.BlameChunk[] sortedChunks = this.mChunks.toArray(new Blame.BlameChunk[this.mChunks.size()]);
        ChunkDateComparator chunkComp = new ChunkDateComparator();
        Arrays.sort(sortedChunks, chunkComp);
        this.mMinAge = sortedChunks[0].getInfo().getDate();
        this.mMaxAge = sortedChunks[sortedChunks.length - 1].getInfo().getDate();
        LinkedHashMap<String, List<Blame.BlameChunk>> ages = new LinkedHashMap<String, List<Blame.BlameChunk>>();
        for (Blame.BlameChunk chunk : sortedChunks) {
            date = chunk.getInfo().getDate();
            String age = this.formatAge(date);
            AgeColourer.addToListInMap(ages, age, chunk);
        }
        int MAX_LEGEND_SIZE = 10;
        if (ages.size() > 10) {
            this.mChunkMap = new TLongObjectHashMap(0);
            long start = this.mMinAge - 1L;
            for (int i2 = 0; i2 < 9; ++i2) {
                date = this.mMinAge + (this.mMaxAge - this.mMinAge) * (long)i2 / 10L;
                this.collectChunks(sortedChunks, start, date);
                start = date;
            }
            this.collectChunks(sortedChunks, start, this.mMaxAge);
        } else if (ages.size() == 0) {
            this.mChunkMap = new TLongObjectHashMap(0);
        } else {
            this.mChunkMap = new TLongObjectHashMap();
            for (Map.Entry entry : ages.entrySet()) {
                String age = (String)entry.getKey();
                List chunkList = (List)entry.getValue();
                Blame.BlameChunk firstChunk = (Blame.BlameChunk)chunkList.get(0);
                long key = firstChunk.getInfo().getDate();
                this.addNewChunkGroup(key);
                for (Blame.BlameChunk chunk : chunkList) {
                    AgeColourer.addToChunkGroupInMap(this.mChunkMap, key, chunk);
                }
            }
        }
        this.mLegendNames = this.mChunkMap.keys();
        Arrays.sort(this.mLegendNames);
    }

    private void collectChunks(Blame.BlameChunk[] sortedChunks, long from, long to) {
        this.addNewChunkGroup(to);
        for (Blame.BlameChunk chunk : sortedChunks) {
            long chunkDate = chunk.getInfo().getDate();
            if (from < chunkDate && chunkDate <= to) {
                AgeColourer.addToChunkGroupInMap(this.mChunkMap, to, chunk);
            }
            if (chunk.getInfo().getDate() > to) break;
        }
    }

    public String formatAge(long age) {
        return "> " + DateHelper.age(age, this.mNow);
    }

    private void addNewChunkGroup(long to) {
        this.mChunkMap.put(to, (Object)new AnnotationColourer.ChunkGroup());
    }

    public int getLegendSize() {
        return this.mChunkMap.size();
    }

    public String getLegendStyle(int i2) {
        return "annotAge" + this.getLegendStyleKey(i2);
    }

    public String getLegendName(int i2) {
        return this.formatAge(this.getLegendKey(i2));
    }

    public long getLegendKey(int i2) {
        return this.mLegendNames[i2];
    }

    public int getLegendLOC(int i2) {
        AnnotationColourer.ChunkGroup chunks = (AnnotationColourer.ChunkGroup)this.mChunkMap.get(this.mLegendNames[i2]);
        return chunks.getChunkTotal();
    }

    public int getLegendStyleKey(int i2) {
        return this.dateToStyle(this.getLegendKey(i2));
    }

    public String getLineStyle(int idx, Blame.BlameChunk chunk) {
        return "annotAge" + this.dateToStyle(chunk.getInfo().getDate());
    }

    public TLongObjectHashMap getChunkMap() {
        return this.mChunkMap;
    }

    private int dateToStyle(long date) {
        return this.scaleDate(date, 0, 256);
    }

    private int scaleDate(long date, int low, int high) {
        float z = (float)(date - this.mMinAge) / (float)(this.mMaxAge - this.mMinAge + 1L);
        return (int)(z * (float)(high - low) + (float)low);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChunkDateComparator
    implements Comparator<Blame.BlameChunk> {
        private ChunkDateComparator() {
        }

        @Override
        public int compare(Blame.BlameChunk b1, Blame.BlameChunk b2) {
            long thisVal = b1.getInfo().getDate();
            long anotherVal = b2.getInfo().getDate();
            return CompareUtil.compareTo(thisVal, anotherVal);
        }
    }
}

