/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import java.util.List;
import java.util.TreeSet;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class DatasetUtils {
    static void buildSteps(XYSeries[] seriess) {
        for (int i2 = 0; i2 < seriess.length; ++i2) {
            XYSeries xySeries = seriess[i2];
            XYSeries newSeries = new XYSeries(xySeries.getKey(), xySeries.getAutoSort(), xySeries.getAllowDuplicateXValues());
            List items = xySeries.getItems();
            XYDataItem prevDataItem = null;
            for (XYDataItem xyDataItem : items) {
                if (prevDataItem != null) {
                    XYDataItem item = new XYDataItem(xyDataItem.getX(), prevDataItem.getY());
                    newSeries.add(item);
                }
                newSeries.add(xyDataItem);
                prevDataItem = xyDataItem;
            }
            seriess[i2] = newSeries;
        }
    }

    static void rectangulariseData(XYSeries[] seriess) {
        TreeSet<Number> domainSet = new TreeSet<Number>();
        for (int i2 = 0; i2 < seriess.length; ++i2) {
            XYSeries xySeries = seriess[i2];
            List items = xySeries.getItems();
            for (XYDataItem xyDataItem : items) {
                domainSet.add(xyDataItem.getX());
            }
        }
        for (Number number : domainSet) {
            for (int i3 = 0; i3 < seriess.length; ++i3) {
                XYSeries xySeries = seriess[i3];
                int index = xySeries.indexOf(number);
                if (index >= 0) continue;
                XYDataItem prevDataItem = DatasetUtils.getItemBefore(xySeries, number);
                xySeries.add(number, prevDataItem.getY());
            }
        }
    }

    private static XYDataItem getItemBefore(XYSeries series, Number xvalue) {
        int count = series.getItemCount();
        XYDataItem beforeItem = new XYDataItem(0.0, 0.0);
        for (int i2 = count - 1; i2 >= 0; --i2) {
            XYDataItem currItem = series.getDataItem(i2);
            Number currX = currItem.getX();
            if (currX.longValue() > xvalue.longValue()) continue;
            beforeItem = currItem;
            break;
        }
        return beforeItem;
    }
}

