/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.bucket.CalculatedBucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.util.StringUtils;

public class ImageMapUtils {
    public static XYToolTipGenerator getXYToolTipGenerator(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        return new StandardXYToolTipGenerator(format, (DateFormat)dateFormat, NumberFormat.getInstance());
    }

    public static XYToolTipGenerator getXYToolTipGeneratorCustom(CalculatedBucketGraph graph) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        CustomXYToolTipGenerator result = new CustomXYToolTipGenerator();
        result.addToolTipSeries(graph.getRevcountTooltips());
        return result;
    }

    public static String getImageMapForSubplots(String name, CalculatedBucketGraphXY graphs) {
        return ImageMapUtils.getImageMapForSubplots(name, graphs, (ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
    }

    public static String getImageMapForSubplots_old(String name, ChartRenderingInfo info) {
        return ImageMapUtils.getImageMapForSubplots_old(name, info, (ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
    }

    public static String getImageMapForSubplots_old(String name, ChartRenderingInfo info, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) {
        StringBuffer sb = ImageMapUtils.beginImageMap(name);
        EntityCollection entities = info.getEntityCollection();
        if (entities != null) {
            int count = entities.getEntityCount();
            int subPlotCount = info.getPlotInfo().getSubplotCount();
            int subPlotIndex = subPlotCount - 1;
            XYItemEntity nextEntity = null;
            for (int i2 = count - 1; i2 >= 0 && subPlotIndex >= 0; --i2) {
                XYItemEntity entity = (XYItemEntity)entities.getEntity(i2);
                if (entity.getToolTipText() == null && entity.getURLText() == null) continue;
                ChartEntity prevEntity = entity.getItem() > 0 ? entities.getEntity(i2 - 1) : null;
                String area = ImageMapUtils.getAreaTagSnappedToClosestX(subPlotIndex, prevEntity, entity, nextEntity, info, toolTipTagFragmentGenerator, urlTagFragmentGenerator);
                if (area.length() > 0) {
                    sb.append(area);
                    sb.append(StringUtils.getLineSeparator());
                }
                nextEntity = entity;
                if (prevEntity != null) continue;
                --subPlotIndex;
                nextEntity = null;
            }
        }
        return ImageMapUtils.endImageMap(sb);
    }

    public static String getImageMapForSubplots(String name, CalculatedBucketGraphXY graphs, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) {
        int rectWidth = 2;
        ChartRenderingInfo info = graphs.getChartRenderingInfo();
        int minX = (int)Math.floor(info.getPlotInfo().getSubplotInfo(0).getDataArea().getMinX());
        int maxX = (int)Math.ceil(info.getPlotInfo().getSubplotInfo(0).getDataArea().getMaxX());
        long minDate = graphs.getStartDate().getTime();
        long maxDate = graphs.getEndDate().getTime();
        StringBuffer sb = ImageMapUtils.beginImageMap(name);
        int y1 = (int)info.getPlotInfo().getPlotArea().getMinY();
        int y2 = (int)info.getPlotInfo().getPlotArea().getMaxY();
        for (int x = minX; x < maxX; x += rectWidth) {
            double ratio = (double)(x - minX) / (double)(maxX - minX);
            long date = Math.round((double)minDate + (double)(maxDate - minDate) * ratio);
            sb.append(ImageMapUtils.getImageMapElement(x, y1, y2, date, rectWidth));
            sb.append(StringUtils.getLineSeparator());
        }
        return ImageMapUtils.endImageMap(sb);
    }

    private static String endImageMap(StringBuffer sb) {
        sb.append("</map>");
        return sb.toString();
    }

    private static StringBuffer beginImageMap(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<map id=\"").append(name).append("\" name=\"").append(name).append("\">");
        sb.append(StringUtils.getLineSeparator());
        return sb;
    }

    private static String getImageMapElement(int x, int y1, int y2, long date, int width) {
        StringBuffer tag = new StringBuffer();
        int x2 = x + width;
        String coords = x + "," + y1 + "," + x2 + "," + y2;
        tag.append("<area shape=\"").append("rect").append("\" coords=\"").append(coords).append("\"");
        tag.append("href=\"?todate=" + date + "\"");
        tag.append("/>");
        return tag.toString();
    }

    private static String getAreaTagSnappedToClosestX(int subPlotIndex, ChartEntity prevEntity, XYItemEntity entity, XYItemEntity nextEntity, ChartRenderingInfo info, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) {
        boolean hasToolTip;
        StringBuffer tag = new StringBuffer();
        boolean hasURL = entity.getURLText() != null && !entity.getURLText().equals("");
        boolean bl = hasToolTip = entity.getToolTipText() != null && !entity.getToolTipText().equals("");
        if (entity.getArea() instanceof Rectangle2D && (hasURL || hasToolTip)) {
            int nextX;
            int prevX;
            Rectangle2D prevShape;
            PlotRenderingInfo plotinfo;
            Rectangle2D shape = (Rectangle2D)entity.getArea();
            PlotRenderingInfo plotRenderingInfo = plotinfo = subPlotIndex >= 0 ? info.getPlotInfo().getSubplotInfo(subPlotIndex) : info.getPlotInfo();
            if (prevEntity != null && nextEntity != null) {
                prevShape = (Rectangle2D)prevEntity.getArea();
                Rectangle2D nextShape = (Rectangle2D)nextEntity.getArea();
                prevX = (int)shape.getX() - ImageMapUtils.calculateHalfDistanceTo(prevShape, shape);
                nextX = (int)shape.getX() + ImageMapUtils.calculateHalfDistanceTo(shape, nextShape);
            } else if (prevEntity != null) {
                prevShape = (Rectangle2D)prevEntity.getArea();
                nextX = (int)plotinfo.getDataArea().getX() + (int)plotinfo.getDataArea().getWidth();
                prevX = (int)shape.getX() - ImageMapUtils.calculateHalfDistanceTo(prevShape, shape);
            } else if (nextEntity != null) {
                Rectangle2D nextShape = (Rectangle2D)nextEntity.getArea();
                nextX = (int)shape.getX() + ImageMapUtils.calculateHalfDistanceTo(shape, nextShape);
                prevX = (int)plotinfo.getDataArea().getX();
            } else {
                prevX = 0;
                nextX = 0;
            }
            int x1 = prevX;
            int y1 = (int)plotinfo.getPlotArea().getY();
            int x2 = nextX;
            int y2 = y1 + (int)plotinfo.getPlotArea().getHeight();
            String coords = x1 + "," + y1 + "," + x2 + "," + y2;
            tag.append("<area shape=\"").append(entity.getShapeType()).append("\" coords=\"").append(coords).append("\"");
            if (hasToolTip) {
                tag.append(toolTipTagFragmentGenerator.generateToolTipFragment(entity.getToolTipText()));
            }
            if (hasURL) {
                tag.append(urlTagFragmentGenerator.generateURLFragment(entity.getURLText()));
            }
            if (!hasToolTip) {
                tag.append(" alt=\"\"");
            }
            tag.append("/>");
        }
        return tag.toString();
    }

    private static int calculateHalfDistanceTo(Rectangle2D fromShape, Rectangle2D toShape) {
        return ((int)Math.ceil(toShape.getX()) - (int)Math.floor(fromShape.getX())) / 2;
    }
}

