/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import com.cenqua.fisheye.vis.ImageMapUtils;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.web.UserProfile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.VerticalAlignment;

public abstract class LineCountChart {
    private Marker mMarker = null;
    private final TickUnitSource TICK_UNITS = this.createEngineeringTickUnits();
    static final int NUM_TICKS_LINECOUNT = 6;
    static final int NUM_TICKS_REVCOUNT = 4;
    static final int NUM_TICKS_LINECOUNT_MINI = 4;

    abstract XYPlot createLineCountPlot(XYSeriesCollection var1, boolean var2);

    abstract XYPlot createCommitHistoryPlot(XYDataset var1, boolean var2, boolean var3);

    void addDomainMarker(XYPlot plot) {
        if (this.mMarker != null) {
            plot.addDomainMarker(this.mMarker, Layer.FOREGROUND);
        }
    }

    public BufferedImage renderPathHistoryImage(CalculatedBucketGraphXY graphs, int w, int h2, XYURLGenerator urlGenerator, TimeZone timezone, boolean isMiniChart) {
        if (graphs.noGraphData()) {
            return new BufferedImage(w, h2, 2);
        }
        JFreeChart chart = this.createLineCommitHistoryChart(graphs, urlGenerator, timezone, isMiniChart);
        return LineCountChartUtils.renderChart(chart, graphs, w, h2);
    }

    JFreeChart createLineCommitHistoryChart(CalculatedBucketGraphXY graphs, XYURLGenerator urlGenerator, TimeZone timezone, boolean isMiniChart) {
        XYPlot lcPlot = this.createLineCountPlot(graphs.getLinecountCollection(), isMiniChart);
        XYPlot volPlot = isMiniChart ? this.createCommitHistoryPlot((XYDataset)graphs.getRevisioncountCollection(), isMiniChart, true) : this.createCommitHistoryPlot((XYDataset)graphs.getRevcountForStack(), isMiniChart, true);
        return this.createComboChart(urlGenerator, graphs, lcPlot, volPlot, isMiniChart, timezone);
    }

    void setRange(DateAxis domainAxis, CalculatedBucketGraphXY graphs) {
        domainAxis.setMinimumDate(graphs.getStartDate());
        domainAxis.setMaximumDate(graphs.getEndDate());
    }

    JFreeChart createComboChart(XYURLGenerator urlGenerator, CalculatedBucketGraphXY graphs, XYPlot lcPlot, XYPlot volPlot, boolean isMiniChart, TimeZone timezone) {
        DateAxis domainAxis = this.createDateAxis(timezone, graphs, isMiniChart);
        CombinedDomainXYPlot comboPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        if (isMiniChart) {
            comboPlot.setGap(8.0);
        } else {
            comboPlot.setGap(10.0);
        }
        lcPlot.setRangeZeroBaselineVisible(true);
        volPlot.setRangeZeroBaselineVisible(true);
        comboPlot.add(lcPlot, 3);
        comboPlot.add(volPlot, 1);
        comboPlot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart((Plot)comboPlot);
        chart.setPadding(new RectangleInsets(1.0, 1.0, 1.0, 15.0));
        chart.setBackgroundPaint((Paint)Color.white);
        if (!graphs.isShowLegend()) {
            chart.removeLegend();
        } else {
            chart.getLegend().setPosition(RectangleEdge.BOTTOM);
            chart.getLegend().setVerticalAlignment(VerticalAlignment.CENTER);
            chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            chart.getLegend().setMargin(15.0, 0.0, 0.0, 0.0);
        }
        volPlot.getRenderer().setBaseToolTipGenerator(ImageMapUtils.getXYToolTipGeneratorCustom(graphs));
        volPlot.getRenderer().setURLGenerator(urlGenerator);
        lcPlot.getRenderer().setBaseToolTipGenerator(ImageMapUtils.getXYToolTipGenerator("{2} - {1} {0}"));
        lcPlot.getRenderer().setURLGenerator(urlGenerator);
        return chart;
    }

    boolean isVisibleInLegend(CalculatedBucketGraphXY graphs, boolean isMiniChart) {
        return !isMiniChart && graphs.isShowLegend();
    }

    XYPlot createXYPlot(XYDataset data, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer, int numTicks) {
        XYPlot plot = new XYPlot(data, domainAxis, rangeAxis, renderer);
        plot.setForegroundAlpha(1.0f);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setOutlineVisible(false);
        plot.setRangeGridlinePaint((Paint)LineCountChartUtils.GRIDLINES);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f, 2, 2, 1.0f, new float[]{0.5f, 0.5f}, 0.5f));
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        if (rangeAxis != null) {
            rangeAxis.setStandardTickUnits(this.getEngineeringTickUnits(rangeAxis.getUpperBound(), numTicks));
        }
        return plot;
    }

    ValueAxis createValueAxis() {
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeMinimumSize(2.0, true);
        rangeAxis.setTickMarksVisible(false);
        rangeAxis.setTickLabelPaint((Paint)LineCountChartUtils.AXIS_LABELS);
        rangeAxis.setAxisLineVisible(false);
        return rangeAxis;
    }

    private TickUnitSource createEngineeringTickUnits() {
        TickUnits units = new TickUnits();
        for (double i2 = 1.0; i2 < Double.MAX_VALUE; i2 *= 10.0) {
            units.add((TickUnit)new EngineeringNumberTickUnit(i2));
            units.add((TickUnit)new EngineeringNumberTickUnit(2.0 * i2));
            units.add((TickUnit)new EngineeringNumberTickUnit(5.0 * i2));
        }
        return units;
    }

    TickUnitSource getEngineeringTickUnits(double maxValue, int numTicks) {
        TickUnits units = new TickUnits();
        double baseValue = maxValue / (double)numTicks;
        this.createEngineeringTickUnits().getCeilingTickUnit(baseValue);
        for (int i2 = 0; i2 < numTicks; ++i2) {
            units.add(this.TICK_UNITS.getCeilingTickUnit(baseValue * (double)(i2 + 1)));
        }
        return units;
    }

    DateAxis createDateAxis(TimeZone timezone, CalculatedBucketGraphXY graph, boolean isMiniChart) {
        DateAxis domainAxis = new DateAxis();
        domainAxis.setLowerMargin(0.1);
        domainAxis.setUpperMargin(0.1);
        domainAxis.setAutoRange(true);
        domainAxis.setAutoTickUnitSelection(true);
        domainAxis.setTickUnit(new DateTickUnit(2, 4), true, false);
        domainAxis.setTickLabelPaint((Paint)LineCountChartUtils.AXIS_LABELS);
        domainAxis.setTimeZone(timezone);
        this.setRange(domainAxis, graph);
        if (!isMiniChart) {
            domainAxis.setAxisLineVisible(false);
            domainAxis.setTickMarksVisible(false);
        }
        return domainAxis;
    }

    public static TimeZone getGraphTimeZone(HttpServletRequest req) {
        UserLogin user;
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        if (req != null && (user = AppConfig.getsConfig().getUserManager().getCurrentUser(req)) != null) {
            try {
                UserProfile up = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                String preferedTZ = up.getEffectiveTimezone();
                if (preferedTZ != null) {
                    tz = TimeZone.getTimeZone(preferedTZ);
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return tz;
    }

    public void addDateRangeMarker(long d1, long d2, Color colour) {
        this.mMarker = new IntervalMarker((double)d1, (double)d2, (Paint)colour, (Stroke)new BasicStroke(1.0f), (Paint)colour, (Stroke)new BasicStroke(1.0f), 1.0f);
    }

    public static class EngineeringNumberTickUnit
    extends NumberTickUnit {
        DecimalFormat df = new DecimalFormat("0.###");

        public EngineeringNumberTickUnit(double v) {
            super(v);
        }

        public EngineeringNumberTickUnit(double v, DecimalFormat numberFormat) {
            super(v);
            this.df = numberFormat;
        }

        public String valueToString(double value) {
            return LargeNumberFormatter.formatValue(this.df, value);
        }
    }
}

