/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.fisheye.web.CookiePreferences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class DirectorySorter {
    public static final LastCommitSorter LAST_COMMIT_SORTER = new LastCommitSorter();
    public static final FirstCommitSorter FIRST_COMMIT_SORTER = new FirstCommitSorter();
    public static final PathNameSorter PATH_SORTER = new PathNameSorter();

    public static List sortLastCommitFirst(List paths, RevisionCache db) {
        return DirectorySorter.sortByDirInfo(paths, db, LAST_COMMIT_SORTER);
    }

    public static List sortFirstCommitFirst(List paths, RevisionCache db) {
        return DirectorySorter.sortByDirInfo(paths, db, FIRST_COMMIT_SORTER);
    }

    public static List sortByPerference(List paths, RevisionCache db, CookiePreferences up) {
        String code = up.getPreference("dirListOrder");
        if ("l".equals(code)) {
            return DirectorySorter.sortLastCommitFirst(paths, db);
        }
        if ("f".equals(code)) {
            return DirectorySorter.sortFirstCommitFirst(paths, db);
        }
        long t0 = System.currentTimeMillis();
        Collections.sort(paths, PATH_SORTER);
        long t1 = System.currentTimeMillis();
        Logs.PERF_LOG.debug((Object)("sorted " + paths.size() + " directories by path in " + (t1 - t0) + "ms"));
        return paths;
    }

    private static List sortByDirInfo(List paths, RevisionCache db, Comparator sorter) {
        long t0 = System.currentTimeMillis();
        List dirInfos = DirectorySorter.pathsToDirInfos(paths, db);
        long t1 = System.currentTimeMillis();
        Collections.sort(dirInfos, sorter);
        List resultPaths = DirectorySorter.dirInfosToPaths(dirInfos);
        long t2 = System.currentTimeMillis();
        Logs.PERF_LOG.debug((Object)("sorted " + paths.size() + " directories by dirinfo in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms"));
        return resultPaths;
    }

    private static List dirInfosToPaths(List dirInfos) {
        ArrayList<Path> resultPaths = new ArrayList<Path>(dirInfos.size());
        for (DirInfo d2 : dirInfos) {
            resultPaths.add(d2.getPath());
        }
        return resultPaths;
    }

    private static List pathsToDirInfos(List paths, RevisionCache db) {
        ArrayList<DirInfo> dirInfos = new ArrayList<DirInfo>(paths.size());
        for (Path p : paths) {
            try {
                DirInfo d2 = db.findDirInfo(p);
                if (d2 == null) continue;
                dirInfos.add(d2);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"problem sorting directories ", (Throwable)e2);
            }
        }
        return dirInfos;
    }

    public static class FirstCommitSorter
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            MinMaxLongRange br;
            DirInfo a2 = (DirInfo)o1;
            DirInfo b2 = (DirInfo)o2;
            MinMaxLongRange ar = a2.getSubTreeDateRange();
            int cmp = ar.compareMin(br = b2.getSubTreeDateRange(), true);
            if (cmp == 0) {
                cmp = a2.getPath().compareTo(b2.getPath());
            }
            return cmp;
        }
    }

    public static class LastCommitSorter
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            DirInfo a2 = (DirInfo)o1;
            DirInfo b2 = (DirInfo)o2;
            MinMaxLongRange ar = a2.getSubTreeDateRange();
            MinMaxLongRange br = b2.getSubTreeDateRange();
            int cmp = ar.compareMax(br, true);
            if ((cmp = -cmp) == 0) {
                cmp = a2.getPath().compareTo(b2.getPath());
            }
            return cmp;
        }
    }

    public static class PathNameSorter
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            Path a2 = (Path)o1;
            Path b2 = (Path)o2;
            return a2.getPath().compareToIgnoreCase(b2.getPath());
        }
    }
}

