/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.IndexedLineReaderSectionView;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.web.DiffExplorer;

public class FileDiffExplorer
extends DiffExplorer {
    private final IndexedLineReader mLR1;
    private final IndexedLineReader mLR2;
    private final RegionList syntaxHiglightsR1;
    private final RegionList syntaxHiglightsR2;

    public FileDiffExplorer(IndexedLineReader LR1, IndexedLineReader LR2, HunkList hunks, String r1Desc, String r2Desc, SyntaxDefinition syntaxDefinition, boolean sideBySide, boolean softWrap) {
        super(r2Desc, hunks, r1Desc, sideBySide, softWrap);
        this.mLR1 = LR1;
        this.mLR2 = LR2;
        this.syntaxHiglightsR1 = this.createRegionList(syntaxDefinition, this.mLR1);
        this.syntaxHiglightsR2 = this.createRegionList(syntaxDefinition, this.mLR2);
    }

    private RegionList createRegionList(SyntaxDefinition syntaxDefinition, IndexedLineReader reader) {
        RegionList regions = new RegionList();
        syntaxDefinition.generateRegions(new InputState(reader.getCharSequence()), regions);
        return regions;
    }

    public IndexedLineReader getLines1() {
        return this.mLR1;
    }

    public IndexedLineReader getLines2() {
        return this.mLR2;
    }

    protected SectionView makeSectionView(Section s) {
        return new IndexedLineReaderSectionView(s, this.mLR1, this.mLR2, this.syntaxHiglightsR1, this.syntaxHiglightsR2);
    }
}

