/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.query.ReturnClause;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.UrlHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SearchResultsExplorer {
    private final int mPageSize = 30;
    private final SearchResults mHits;
    private UrlHelper mBaseUrl;
    private int mThisPageNum;
    private int mTotalPages;
    private int mNeighbours = 10;
    private int mNeighbourPageNum;

    public SearchResultsExplorer(SearchResults hits) {
        this.mHits = hits;
    }

    public void init(HttpServletRequest req, UrlHelper base) {
        this.mBaseUrl = base;
        boolean firstPageNum = true;
        int lastPageNum = this.getSize() / 30 + 1;
        if ((lastPageNum - 1) * 30 >= this.getSize()) {
            --lastPageNum;
        }
        int thisPageNum = 1;
        String thisPageNumStr = req.getParameter("spage");
        if (thisPageNumStr != null) {
            try {
                thisPageNum = Integer.parseInt(thisPageNumStr);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        thisPageNum = Math.min(thisPageNum, lastPageNum);
        this.mThisPageNum = thisPageNum = Math.max(thisPageNum, 1);
        this.mTotalPages = lastPageNum;
    }

    public UrlHelper getBaseUrl() {
        return this.mBaseUrl;
    }

    public int getThisPageNum() {
        return this.mThisPageNum;
    }

    public int getTotalPages() {
        return this.mTotalPages;
    }

    public boolean isEmpty() {
        return this.mHits.size() == 0;
    }

    public int getSize() {
        return this.mHits.size();
    }

    public int getIterationStart() {
        return 30 * (this.mThisPageNum - 1);
    }

    public int getIterationEnd() {
        int len = this.getIterationStart() + 30;
        return Math.min(len, this.getSize());
    }

    public Iterator getItems() throws DbException {
        final int start = this.getIterationStart();
        final int end = this.getIterationEnd();
        final SearchResults.RevisionResultsIterator iter = this.mHits.iterateRevisions(start);
        return new Iterator(){
            int i;
            {
                this.i = start;
            }

            public boolean hasNext() {
                return this.i < end;
            }

            public Object next() {
                ++this.i;
                return iter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getTabularRows() throws DbException {
        final int start = this.getIterationStart();
        final int end = this.getIterationEnd();
        final SearchResults.TabularResultsIterator iter = this.mHits.iterateData(start);
        return new Iterator(){
            int i;
            {
                this.i = start;
            }

            public boolean hasNext() {
                return this.i < end;
            }

            public Object next() {
                try {
                    SearchResults.ResultRow row = iter.nextRow();
                    boolean startOfGroup = SearchResultsExplorer.this.mHits.isGrouped() && iter.isStartOfGroup();
                    RowDetail rowDetail = new RowDetail(row, this.i, startOfGroup, SearchResultsExplorer.this.mHits.getMetaData());
                    ++this.i;
                    return rowDetail;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List getTabularColumnNames() {
        ReturnClause md = this.mHits.getMetaData();
        ArrayList<String> result = new ArrayList<String>(md.numFields());
        for (int i2 = 0; i2 < md.numFields(); ++i2) {
            result.add(md.getField(i2).getColumnName());
        }
        return result;
    }

    public List getGroups() throws Exception {
        int start = this.getIterationStart();
        int end = this.getIterationEnd();
        SearchResults.RevisionResultsIterator iter = this.mHits.iterateRevisions(start);
        ArrayList<GroupItem> groups = new ArrayList<GroupItem>(end - start);
        GroupItem group = null;
        for (int i2 = start; i2 < end; ++i2) {
            FileRevision item = iter.nextItem();
            boolean startOfGroup = iter.isStartOfGroup();
            if (group == null || startOfGroup) {
                group = new GroupItem(!startOfGroup);
                groups.add(group);
            }
            group.add(item);
        }
        if (group != null && iter.hasNext()) {
            iter.nextItem();
            if (!iter.isStartOfGroup()) {
                group.setMoreItemsInGroup(true);
            }
        }
        return groups;
    }

    public String getResultType() {
        return this.mHits.getType();
    }

    public boolean isTabularData() {
        return this.mHits.hasTabularResults();
    }

    public boolean isTruncated() {
        return this.mHits.isTruncated();
    }

    public int getPreTruncatedSize() {
        return this.mHits.getPreTruncateSize();
    }

    public int getPostTruncatedSize() {
        return this.mHits.getPostTruncateSize();
    }

    public String getLinkPrevious() {
        return this.getURL(this.mThisPageNum > 1, this.mThisPageNum - 1, "&lt&lt previous");
    }

    public String getLinkFirst() {
        return this.getURL(this.mThisPageNum > this.mNeighbours + 1, 1, "1");
    }

    private String getURL(boolean condition, int page, String text) {
        if (!condition) {
            return "";
        }
        UrlHelper url = this.mBaseUrl.getClone();
        url.putParam("spage", page);
        return "<a href=" + url.getUrl() + "> " + text + " </a>";
    }

    public String getFirstEllipsis() {
        if (this.mThisPageNum > this.mNeighbours + 2) {
            return "&#0133";
        }
        return "";
    }

    public String getPageUrl(int page) {
        UrlHelper url = this.mBaseUrl.getClone();
        url.putParam("spage", page);
        return url.toString();
    }

    public String getPageUrlNext(int page) {
        UrlHelper url = this.mBaseUrl.getClone();
        url.putParam("spage", page);
        return url.toString();
    }

    public boolean showLinkPrevious() {
        return this.mThisPageNum > 1;
    }

    public boolean showLink1() {
        return this.mThisPageNum > this.mNeighbours + 1;
    }

    public boolean showLinkLast() {
        return this.mThisPageNum + this.mNeighbours < this.mTotalPages;
    }

    public boolean showLinkNext() {
        return this.mThisPageNum < this.mTotalPages;
    }

    public boolean showFirstEllipsis() {
        return this.mThisPageNum > this.mNeighbours + 2;
    }

    public boolean showSecondEllipsis() {
        return this.mThisPageNum + this.mNeighbours < this.mTotalPages - 1;
    }

    public void initNeighbours() {
        this.mNeighbourPageNum = this.getMinPage();
    }

    public void nextNeighbour() {
        ++this.mNeighbourPageNum;
    }

    public String getNeighbourUrl() {
        return this.getPageUrl(this.mNeighbourPageNum);
    }

    public int getMinPage() {
        return Math.max(this.mThisPageNum - this.mNeighbours, 1);
    }

    public int getMaxPage() {
        return Math.min(this.mThisPageNum + this.mNeighbours, this.mTotalPages);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupItem {
        private final List<FileRevision> items = new LinkedList<FileRevision>();
        private final boolean previousItemsInGroup;
        private boolean moreItemsInGroup = false;

        public GroupItem(boolean previousItemsInGroup) {
            this.previousItemsInGroup = previousItemsInGroup;
        }

        void add(FileRevision item) {
            this.items.add(item);
        }

        void setMoreItemsInGroup(boolean moreItemsInGroup) {
            this.moreItemsInGroup = moreItemsInGroup;
        }

        public boolean isPreviousItemsInGroup() {
            return this.previousItemsInGroup;
        }

        public boolean isMoreItemsInGroup() {
            return this.moreItemsInGroup;
        }

        public FileRevision getFirst() {
            return this.items.get(0);
        }

        public List<FileRevision> getItems() {
            return this.items;
        }

        public Set<Integer> getReviewIds() {
            LinkedHashSet<Integer> reviewIds = new LinkedHashSet<Integer>();
            for (FileRevision frx : this.items) {
                reviewIds.addAll(frx.getReviewIds());
            }
            return reviewIds;
        }
    }

    public static class CellDetail {
        private final SearchResults.ResultRow row;
        private final int index;
        private final ReturnClause.Field field;

        public CellDetail(SearchResults.ResultRow row, int index, ReturnClause.Field field) {
            this.row = row;
            this.index = index;
            this.field = field;
        }

        public boolean isNumber() {
            return this.field.isInt();
        }

        public boolean isDate() {
            return this.field.isDate();
        }

        public String getField() {
            return this.field.getField();
        }

        public String getAsString() {
            return this.row.getString(this.index);
        }

        public String getAsStringArray() {
            return this.row.getStringFromArray(this.index);
        }

        public Map[] getAsMapArray() {
            return this.row.getMapArray(this.index);
        }

        public Path getAsPath() {
            return this.row.getPath(this.index);
        }

        public int getAsInt() {
            return this.row.getInt(this.index);
        }

        public long getAsDate() {
            return this.row.getDate(this.index);
        }

        public Collection getAsList() {
            return this.row.getList(this.index);
        }
    }

    public static class RowDetail {
        private final SearchResults.ResultRow row;
        private final int rowIndex;
        private final boolean startOfGroup;
        private final ReturnClause metadata;

        public RowDetail(SearchResults.ResultRow row, int rowIndex, boolean startOfGroup, ReturnClause metadata) {
            this.row = row;
            this.rowIndex = rowIndex;
            this.startOfGroup = startOfGroup;
            this.metadata = metadata;
        }

        public boolean isStartOfGroup() {
            return this.startOfGroup;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public List getColumns() {
            ArrayList<CellDetail> result = new ArrayList<CellDetail>();
            for (int i2 = 0; i2 < this.metadata.numFields(); ++i2) {
                ReturnClause.Field field = this.metadata.getField(i2);
                result.add(new CellDetail(this.row, i2, field));
            }
            return result;
        }
    }
}

