/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlHelper {
    private String mUrl = "";
    private boolean urlIsEncoded = false;
    private LinkedHashMap<String, String> mParams;

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
        this.urlIsEncoded = false;
    }

    public void setEncodedUrl(String url) {
        this.mUrl = url;
        this.urlIsEncoded = true;
    }

    public Map<String, String> getParams() {
        if (this.mParams == null) {
            this.mParams = new LinkedHashMap();
        }
        return this.mParams;
    }

    public void putMulti(String name, String value) {
        Map<String, String> m = this.getParams();
        LinkedList<String> l = (LinkedList<String>)((Object)m.get(name));
        if (l == null) {
            l = new LinkedList<String>();
            m.put(name, (String)((Object)l));
        }
        l.add(value);
    }

    public void putParam(String name, Object value) {
        if (value == null || value.toString().equals("") || StringUtil.nullOrEmpty(name)) {
            return;
        }
        this.getParams().put(name, value.toString());
    }

    public void putParam(String name, Object[] value) {
        if (StringUtil.nullOrEmpty(name) || value == null) {
            return;
        }
        for (int i2 = 0; i2 < value.length; ++i2) {
            Object o = value[i2];
            String val = o.toString();
            if (StringUtil.nullOrEmpty(val)) continue;
            this.putMulti(name, o.toString());
        }
    }

    public UrlHelper getClone() {
        UrlHelper clone = new UrlHelper();
        clone.mUrl = this.mUrl;
        clone.urlIsEncoded = this.urlIsEncoded;
        clone.mParams = this.mParams == null ? null : new LinkedHashMap<String, String>(this.mParams);
        return clone;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.urlIsEncoded ? this.mUrl : ExpressionUtil.urlEncode(this.mUrl));
        if (this.mParams != null && !this.mParams.isEmpty()) {
            String sep = "";
            if (this.mUrl.indexOf(63) == -1) {
                buf.append('?');
            } else {
                sep = "&";
            }
            for (String key : this.mParams.keySet()) {
                String val = this.mParams.get(key);
                if (val instanceof List) {
                    List l = (List)((Object)val);
                    for (Object val2 : l) {
                        buf.append(sep);
                        buf.append(ExpressionUtil.urlEncode(key));
                        buf.append("=").append(ExpressionUtil.urlEncode(val2.toString()));
                        sep = "&";
                    }
                    continue;
                }
                buf.append(sep);
                buf.append(ExpressionUtil.urlEncode(key));
                buf.append("=").append(ExpressionUtil.urlEncode(String.valueOf(val)));
                sep = "&";
            }
        }
        return buf.toString();
    }
}

