/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUserEAV;
import com.cenqua.fisheye.web.UserProfile;

public class UserProfileManager {
    public static UserProfile DEFAULT_PROFILE = new UserProfile();
    private final InfinityDbHandle db;
    private final Object dbLock;

    public UserProfileManager(InfinityDbHandle db, Object dbLock) {
        this.db = db;
        this.dbLock = dbLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getProfile(String user) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            FEUserEAV ueav = new FEUserEAV(this.db.get());
            UserProfile profile = ueav.loadProfile(user);
            if (profile == null) {
                profile = new UserProfile(user, this.getDefaultProfile());
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfile(String user, UserProfile profile) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            FEUserEAV ueav = new FEUserEAV(this.db.get());
            profile.setUsername(user);
            ueav.updateProfile(profile);
        }
    }

    public UserProfile getDefaultProfile() {
        return new UserProfile(DEFAULT_PROFILE);
    }

    public void setDefaultProfile(UserProfile profile) {
        DEFAULT_PROFILE = new UserProfile("DEFAULT_USER", profile);
    }
}

