/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.P4ConfigType;
import com.opensymphony.xwork.ActionSupport;
import java.io.File;

public class EditP4ConfigAction
extends ActionSupport {
    private P4ConfigType p4Config;

    public P4ConfigType getP4Config() {
        if (this.p4Config == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            if (!cfg.isSetP4Config()) {
                cfg.addNewP4Config();
            }
            this.p4Config = (P4ConfigType)cfg.getP4Config().copy();
        }
        return this.p4Config;
    }

    public String execute() throws Exception {
        P4ConfigType editing = this.getP4Config();
        if (editing.isSetP4Location() && EditP4ConfigAction.nullOrEmpty(editing.getP4Location())) {
            editing.unsetP4Location();
        } else {
            try {
                this.checkFileExists(editing.getP4Location());
            }
            catch (Exception e2) {
                this.addActionMessage("Could not find P4 executable at " + editing.getP4Location());
            }
        }
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        cfg.setP4Config(editing);
        AppConfig.getsConfig().saveConfig();
        return this.hasActionMessages() ? "input" : "success";
    }

    private boolean checkFileExists(String path) {
        try {
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                return true;
            }
            this.addActionMessage(file.getAbsolutePath() + " does not exist or can not be accessed.");
            return false;
        }
        catch (Exception e2) {
            this.addActionMessage("Could not load file - " + path + ". " + e2.getMessage());
            return false;
        }
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

