/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class ManageRepositoryAction
extends BaseRepositoryAction {
    private boolean doStart = false;
    private boolean doStop = false;
    private boolean doRestart = false;

    public boolean isDoStart() {
        return this.doStart;
    }

    public void setDoStart(boolean doStart) {
        this.doStart = doStart;
    }

    public boolean isDoStop() {
        return this.doStop;
    }

    public void setDoStop(boolean doStop) {
        this.doStop = doStop;
    }

    public boolean isDoRestart() {
        return this.doRestart;
    }

    public void setDoRestart(boolean doRestart) {
        this.doRestart = doRestart;
    }

    public String execute() {
        ConfigDocument.Config cfg = this.getCfg();
        try {
            RepositoryType repository = cfg.getRepositoryArray(this.getRep());
            RepositoryManager repositoryManager = AppConfig.getsConfig().getRepositoryManager();
            RepositoryHandle handle = repositoryManager.getRepository(repository.getName());
            try {
                if (!this.getRepositoryHandle().getCfg().isEnabled()) {
                    this.addActionError("Operation not permitted. Repository: '" + handle.getName() + "' is not enabled.");
                } else if (this.doStart) {
                    repositoryManager.runRepository(handle.getName());
                    this.addActionMessage("Started repository: " + handle.getName());
                } else if (this.doStop) {
                    handle.stop();
                    this.addActionMessage("Stopped repository: " + handle.getName());
                } else if (this.doRestart) {
                    boolean stopped = handle.tryStop(5000L);
                    if (stopped) {
                        repositoryManager.runRepository(handle.getName());
                        this.addActionMessage("Restarting repository: " + handle.getName());
                    } else {
                        this.addActionError("Repository took too long to stop, you will need to start it manually.");
                    }
                }
            }
            catch (Exception e2) {
                this.addActionError("A problem occurred starting your repository: " + e2.getMessage() + " (" + e2.getClass().getName() + ")");
                Logs.APP_LOG.warn((Object)"problem starting/stopping repository", (Throwable)e2);
                return "error";
            }
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        return "success";
    }
}

