/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.api;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.web.security.BasicRfc2617Authenticator;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginInterceptor
implements Interceptor {
    private String realmName = "admin-api";

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest req = ServletActionContext.getRequest();
        boolean valid = this.valid(req);
        if (valid) {
            return invocation.invoke();
        }
        HttpServletResponse resp = ServletActionContext.getResponse();
        resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        resp.sendError(401, "Auth required");
        return "none";
    }

    private boolean valid(HttpServletRequest req) {
        BasicRfc2617Authenticator auth = new BasicRfc2617Authenticator();
        if (!auth.containsUsernamePassword(req)) {
            return false;
        }
        if (!"".equals(auth.getUsername())) {
            return false;
        }
        AdminConfig admin = AppConfig.getsConfig().getAdminConfig();
        return admin.verifyAdminPassword(auth.getPassword());
    }
}

